function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import StyledPill from "./pill.style";
import Icon from "../icon";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import IconButton from "../icon-button";
let neutralWhiteWarnTriggered = false;
export const Pill = ({
  wrapText,
  borderColor,
  colorVariant = "neutral",
  isDarkBackground = false,
  children,
  fill = false,
  maxWidth,
  onClick,
  onDelete,
  pillRole = "tag",
  size = "M",
  ariaLabelOfRemoveButton = "remove pill",
  ...rest
}) => {
  if (!neutralWhiteWarnTriggered && !isDarkBackground && colorVariant === "neutralWhite" && !fill) {
    neutralWhiteWarnTriggered = true;
    // eslint-disable-next-line no-console
    console.warn("[WARNING] The `neutralWhite` variant should only be used on dark backgrounds with fill set to true. " + "Please set the `isDarkBackground` and `fill` props to true or use another color variant.");
  }
  return /*#__PURE__*/React.createElement(StyledPill, _extends({
    inFill: fill,
    colorVariant: colorVariant,
    isDarkBackground: isDarkBackground,
    isDeletable: !!onDelete,
    pillRole: pillRole,
    size: size,
    borderColor: borderColor,
    onClick: onClick
  }, tagComponent("pill", rest), {
    maxWidth: maxWidth,
    wrapText: wrapText
  }, rest), children, onDelete && /*#__PURE__*/React.createElement(IconButton, {
    onClick: onDelete,
    "data-element": "close",
    "aria-label": ariaLabelOfRemoveButton
  }, /*#__PURE__*/React.createElement(Icon, {
    type: "cross"
  })));
};
export default Pill;