import React from "react";
import { StyledPillProps } from "./pill.style";
export interface PillProps extends StyledPillProps {
    /** The content to display inside of the pill.  */
    children: string;
    /** Change the color of a status pill. */
    colorVariant?: "neutral" | "negative" | "positive" | "warning" | "information" | "neutralWhite";
    /** Sets the colour styling when a status pill is rendered on a dark background. */
    isDarkBackground?: boolean;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-element"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-role"?: string;
    /** Fills the pill background with colour. When fill is false only the border is coloured. */
    fill?: boolean;
    /** Callback function for when the pill is clicked. */
    onClick?: (ev: React.MouseEvent<HTMLSpanElement>) => void;
    /** Callback function for when the remove icon is clicked. */
    onDelete?: (ev?: React.KeyboardEvent<HTMLButtonElement> | React.MouseEvent<HTMLButtonElement>) => void;
    /** Sets the type of pill in use. */
    pillRole?: "tag" | "status";
    /** Sets custom aria-label attribute on the remove button */
    ariaLabelOfRemoveButton?: string;
    /** @private @ignore title attribute passed down to underlying element */
    title?: string;
}
export declare const Pill: ({ wrapText, borderColor, colorVariant, isDarkBackground, children, fill, maxWidth, onClick, onDelete, pillRole, size, ariaLabelOfRemoveButton, ...rest }: PillProps) => React.JSX.Element;
export default Pill;
