function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef, useState } from "react";
import PropTypes from "prop-types";
import { StyledPassword, HiddenAriaLive } from "./password.style";
import guid from "../../__internal__/utils/helpers/guid";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import useLocale from "../../hooks/__internal__/useLocale";
import ButtonMinor from "../button-minor/button-minor.component";
export const Password = ({
  id,
  disabled,
  forceObscurity = false,
  ...rest
}) => {
  const internalInputId = useRef(id || guid());
  const l = useLocale();
  const [passwordShown, setPasswordShown] = useState(false);
  const visibleInput = !forceObscurity && passwordShown;
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(StyledPassword, _extends({}, tagComponent("password", rest), {
    "data-element": "styled-password-container",
    id: internalInputId.current,
    autoComplete: "off",
    type: visibleInput ? "text" : "password",
    disabled: disabled
  }, rest), /*#__PURE__*/React.createElement(ButtonMinor, {
    "aria-label": visibleInput ? "Hide password" : "Show password",
    "aria-controls": internalInputId.current,
    onClick: () => setPasswordShown(!passwordShown),
    pr: 1,
    buttonType: "tertiary",
    iconType: visibleInput ? "hide" : "view",
    iconPosition: "before",
    size: "small",
    disabled: forceObscurity || disabled,
    isInPassword: true
  }, visibleInput ? "Hide" : "Show")), /*#__PURE__*/React.createElement(HiddenAriaLive, {
    role: "status",
    "aria-live": "polite"
  }, visibleInput ? l.password.ariaLiveShownMessage() : l.password.ariaLiveHiddenMessage()));
};
export default Password;