function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef } from "react";
import PropTypes from "prop-types";
import { CSSTransition } from "react-transition-group";
import tagComponent from "../../../__internal__/utils/helpers/tags/tags";
import FullScreenHeading from "../../../__internal__/full-screen-heading";
import Box from "../../box";
import { StyledPage, StyledPageContent } from "./page.style";
import { filterStyledSystemPaddingProps } from "../../../style/utils";
const Page = ({
  role,
  title,
  children,
  ...rest
}) => {
  const styledPageNodeRef = useRef(null);
  const {
    transitionName
  } = rest;
  return /*#__PURE__*/React.createElement(CSSTransition, _extends({
    className: "carbon-carousel__transition",
    timeout: {
      appear: 0,
      enter: 0,
      exit: 0
    }
  }, transitionName && {
    classNames: transitionName()
  }, {
    nodeRef: styledPageNodeRef
  }, rest), /*#__PURE__*/React.createElement(StyledPage, _extends({}, tagComponent("page", rest), {
    ref: styledPageNodeRef,
    role: role
  }), /*#__PURE__*/React.createElement(FullScreenHeading, {
    hasContent: true
  }, title), /*#__PURE__*/React.createElement(StyledPageContent, _extends({
    "data-element": "carbon-page-content",
    p: "34px 40px"
  }, filterStyledSystemPaddingProps(rest)), /*#__PURE__*/React.createElement(Box, {
    boxSizing: "border-box",
    maxWidth: "100%",
    minWidth: "auto",
    margin: "0 auto"
  }, children))));
};
Page.displayName = "Page";
export default Page;