import React from "react";
import { PaddingProps } from "styled-system";
export interface PageProps extends PaddingProps {
    /** The title for the page, normally a Heading component. */
    title: React.ReactNode;
    /** This component supports children. */
    children: React.ReactNode;
    /** The ARIA role to be applied to the component */
    role?: string;
    /** @ignore @private */
    transitionName?: () => string;
}
declare const Page: {
    ({ role, title, children, ...rest }: PageProps): React.JSX.Element;
    displayName: string;
};
export default Page;
