function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useCallback, useEffect, useRef } from "react";
import PropTypes from "prop-types";
import { Select, Option } from "../select";
import PagerNavigation from "./__internal__/pager-navigation.component";
import useLocale from "../../hooks/__internal__/useLocale";
import createGuid from "../../__internal__/utils/helpers/guid";
import { StyledPagerContainer, StyledPagerSizeOptions, StyledPagerSummary, StyledPagerSizeOptionsInner, StyledSelectContainer } from "./pager.style";
import Events from "../../__internal__/utils/helpers/events";
export const Pager = ({
  currentPage = 1,
  hideDisabledElements = false,
  interactivePageNumber = true,
  pageSizeSelectionOptions = [{
    id: "10",
    name: 10
  }, {
    id: "25",
    name: 25
  }, {
    id: "50",
    name: 50
  }, {
    id: "100",
    name: 100
  }],
  pageSize = 10,
  showPageSizeSelection = false,
  totalRecords = 0,
  onPagination,
  onNext,
  onFirst,
  onPrevious,
  onLast,
  showPageSizeLabelBefore = true,
  showPageSizeLabelAfter = true,
  showTotalRecords = true,
  showFirstAndLastButtons = true,
  showPreviousAndNextButtons = true,
  showPageCount = true,
  variant = "default",
  ...rest
}) => {
  const l = useLocale();
  const [page, setPage] = useState(+currentPage);
  const [currentPageSize, setCurrentPageSize] = useState(+pageSize);
  const [value, setValue] = useState(+pageSize);
  const guid = useRef(createGuid());
  const pageSizeSelectId = `Pager_size_selector_${guid.current}`;
  const getPageCount = useCallback(() => {
    if (+totalRecords < 0 || Number.isNaN(+totalRecords)) {
      return 1;
    }
    return Math.ceil(+totalRecords / currentPageSize);
  }, [totalRecords, currentPageSize]);
  const [pageCount, setPageCount] = useState(getPageCount());
  useEffect(() => {
    setCurrentPageSize(+pageSize);
    setValue(+pageSize);
  }, [pageSize]);
  useEffect(() => {
    const maxPage = getPageCount();
    setPageCount(maxPage);
    if (+currentPage > maxPage) {
      setPage(maxPage);
    } else {
      setPage(+currentPage);
    }
  }, [currentPageSize, pageCount, currentPage, totalRecords, getPageCount]);
  const handleOnFirst = useCallback(e => {
    setPage(1);
    if (onFirst) {
      onFirst(e);
    }
  }, [onFirst]);
  const handleOnLast = useCallback(e => {
    setPage(pageCount);
    if (onLast) {
      onLast(e);
    }
  }, [pageCount, onLast]);
  const handleOnNext = useCallback(e => {
    const nextPage = page + 1;
    setPage(nextPage);
    if (onNext) {
      onNext(e);
    }
  }, [onNext, page]);
  const handleOnPrevious = useCallback(e => {
    const previousPage = page - 1;
    setPage(previousPage);
    if (onPrevious) {
      onPrevious(e);
    }
  }, [page, onPrevious]);
  const handleOnPagination = useCallback(selectedValue => {
    setValue(selectedValue);
    setCurrentPageSize(+selectedValue);
    onPagination(1, +selectedValue, "page-select");
  }, [onPagination]);
  const handleKeyDown = useCallback(e => Events.isEnterKey(e) && handleOnPagination(e.target.value), [handleOnPagination]);
  const sizeSelector = () => {
    return /*#__PURE__*/React.createElement(StyledSelectContainer, null, /*#__PURE__*/React.createElement(Select, _extends({
      value: String(value),
      onChange: ev => setValue(+ev.target.value),
      onBlur: () => setValue(currentPageSize),
      onKeyDown: handleKeyDown,
      "data-element": "page-select",
      id: pageSizeSelectId
    }, !showPageSizeLabelBefore && !showPageSizeLabelAfter ? {
      ariaLabel: l.pager.show()
    } : {}), pageSizeSelectionOptions.map(sizeOption => /*#__PURE__*/React.createElement(Option, {
      key: sizeOption.id,
      text: sizeOption.id,
      value: String(sizeOption.name),
      onClick: handleOnPagination
    }))));
  };
  const renderPageSizeOptions = () => {
    const wrapper = (isLabel, child) => isLabel ? /*#__PURE__*/React.createElement("label", {
      htmlFor: pageSizeSelectId
    }, child) : /*#__PURE__*/React.createElement("div", null, child);
    return showPageSizeSelection && /*#__PURE__*/React.createElement(StyledPagerSizeOptionsInner, null, showPageSizeLabelBefore && wrapper(showPageSizeLabelBefore, l.pager.show()), sizeSelector(), showPageSizeLabelAfter && wrapper(!showPageSizeLabelBefore, l.pager.records(currentPageSize, false)));
  };
  const renderTotalRecords = () => showTotalRecords && l.pager.records(totalRecords);
  return /*#__PURE__*/React.createElement(StyledPagerContainer, _extends({
    "data-component": "pager",
    variant: variant
  }, rest), /*#__PURE__*/React.createElement(StyledPagerSizeOptions, null, renderPageSizeOptions()), /*#__PURE__*/React.createElement(PagerNavigation, {
    pageSize: currentPageSize,
    currentPage: page,
    interactivePageNumber: interactivePageNumber,
    hideDisabledElements: hideDisabledElements,
    setCurrentPage: setPage,
    onNext: handleOnNext,
    onPrevious: handleOnPrevious,
    onFirst: handleOnFirst,
    onLast: handleOnLast,
    onPagination: onPagination,
    pageCount: pageCount,
    showFirstAndLastButtons: showFirstAndLastButtons,
    showPreviousAndNextButtons: showPreviousAndNextButtons,
    showPageCount: showPageCount
  }), /*#__PURE__*/React.createElement(StyledPagerSummary, null, renderTotalRecords()));
};
export default Pager;