function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef } from "react";
import PropTypes from "prop-types";
import { StyledPagerNavigation, StyledPagerNavInner, StyledPagerNoSelect, StyledPagerNavLabel } from "../pager.style";
import NumberInput from "../../number";
import Events from "../../../__internal__/utils/helpers/events";
import createGuid from "../../../__internal__/utils/helpers/guid";
import PagerNavigationLink from "./pager-navigation-link.component";
import useLocale from "../../../hooks/__internal__/useLocale";
const PagerNavigation = ({
  pageSize,
  currentPage,
  setCurrentPage,
  onNext,
  onPrevious,
  onFirst,
  onLast,
  onPagination,
  pageCount,
  showFirstAndLastButtons = true,
  showPreviousAndNextButtons = true,
  showPageCount = true,
  interactivePageNumber = true,
  hideDisabledElements = false
}) => {
  const l = useLocale();
  const guid = useRef(createGuid());
  const currentPageId = `Pager_${guid.current}`;
  const navLabelString = `${l.pager.pageX()} ${currentPage.toString()} ${l.pager.ofY(pageCount)}`;
  const hasOnePage = pageCount <= 1;
  const hasTwoPages = pageCount === 2;
  const pagerNavigationProps = {
    currentPage,
    pageSize,
    pageCount,
    onPagination
  };
  const handlePageInputChange = ev => {
    const pageNumber = +ev.target.value;
    if (pageCount === 0) {
      setCurrentPage(0);
      onPagination(0, pageSize, "input");
      return 0;
    }
    if (pageNumber <= 0 || Number.isNaN(pageNumber)) {
      setCurrentPage(1);
      onPagination(1, pageSize, "input");
      return 1;
    }
    if (pageNumber > pageCount) {
      setCurrentPage(pageCount);
      onPagination(pageCount, pageSize, "input");
      return pageCount;
    }
    setCurrentPage(pageNumber);
    onPagination(pageNumber, pageSize, "input");
    return pageNumber;
  };
  const handleCurrentPageChange = e => {
    setCurrentPage(+e.target.value);
  };
  const renderButtonsBeforeCount = () => /*#__PURE__*/React.createElement(React.Fragment, null, !hasTwoPages && showFirstAndLastButtons && /*#__PURE__*/React.createElement(PagerNavigationLink, _extends({
    type: "first",
    hideDisabledElements: hideDisabledElements,
    onClick: onFirst
  }, pagerNavigationProps)), showPreviousAndNextButtons && /*#__PURE__*/React.createElement(PagerNavigationLink, _extends({
    type: "previous",
    hideDisabledElements: hideDisabledElements,
    onClick: onPrevious
  }, pagerNavigationProps)));
  const renderButtonsAfterCount = () => /*#__PURE__*/React.createElement(React.Fragment, null, showPreviousAndNextButtons && /*#__PURE__*/React.createElement(PagerNavigationLink, _extends({
    type: "next",
    hideDisabledElements: hideDisabledElements,
    onClick: onNext
  }, pagerNavigationProps)), !hasTwoPages && showFirstAndLastButtons && /*#__PURE__*/React.createElement(PagerNavigationLink, _extends({
    type: "last",
    hideDisabledElements: hideDisabledElements,
    onClick: onLast
  }, pagerNavigationProps)));
  return /*#__PURE__*/React.createElement(StyledPagerNavigation, null, !hasOnePage && renderButtonsBeforeCount(), showPageCount && (interactivePageNumber ? /*#__PURE__*/React.createElement(StyledPagerNavInner, null, /*#__PURE__*/React.createElement("label", {
    htmlFor: currentPageId
  }, /*#__PURE__*/React.createElement(StyledPagerNoSelect, null, l.pager.pageX())), /*#__PURE__*/React.createElement(NumberInput, {
    value: currentPage.toString(),
    "data-element": "current-page",
    onChange: handleCurrentPageChange,
    onBlur: handlePageInputChange,
    id: currentPageId,
    onKeyUp: ev => Events.isEnterKey(ev) ? handlePageInputChange(ev) : false
  }), /*#__PURE__*/React.createElement(StyledPagerNoSelect, null, l.pager.ofY(pageCount))) : /*#__PURE__*/React.createElement(StyledPagerNavLabel, {
    "data-element": "current-page-label",
    id: currentPageId,
    "aria-live": "polite"
  }, navLabelString)), !hasOnePage && renderButtonsAfterCount());
};
export default PagerNavigation;