import React from "react";
export interface PagerNavigationProps {
    /** Current visible page */
    currentPage: number;
    /** Pagination page size */
    pageSize: number;
    pageCount: number;
    /** Sets the current page being shown */
    setCurrentPage: (page: number) => void;
    /** Callback function for next link */
    onNext?: (ev: React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** Callback function for first link */
    onFirst?: (ev: React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** Callback function for previous link */
    onPrevious?: (ev: React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** Callback function for last link */
    onLast?: (ev: React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** onPagination Callback triggered when a change is triggered */
    onPagination: (currentPage: number, pageSize: number, origin: string) => void;
    /** Should the `First` and `Last` navigation buttons be shown */
    showFirstAndLastButtons?: boolean;
    /** Should the `Next` and `Previous` navigation buttons be shown */
    showPreviousAndNextButtons?: boolean;
    /** Should the page count input be shown */
    showPageCount?: boolean;
    /** If true, page number navigation will be changed to a non-interactive label */
    interactivePageNumber?: boolean;
    /** If true, sets css property visibility: hidden on all disabled elements  */
    hideDisabledElements?: boolean;
}
declare const PagerNavigation: ({ pageSize, currentPage, setCurrentPage, onNext, onPrevious, onFirst, onLast, onPagination, pageCount, showFirstAndLastButtons, showPreviousAndNextButtons, showPageCount, interactivePageNumber, hideDisabledElements, }: PagerNavigationProps) => React.JSX.Element;
export default PagerNavigation;
