import React, { useRef, useEffect, useCallback } from "react";
import PropTypes from "prop-types";
import { StyledPagerLink } from "../pager.style";
import useLocale from "../../../hooks/__internal__/useLocale";
const PagerNavigationLink = ({
  type,
  currentPage,
  pageCount,
  hideDisabledElements,
  pageSize,
  onClick,
  onPagination
}) => {
  const l = useLocale();
  const linkRef = useRef(null);
  const navLinkConfig = {
    first: {
      text: l.pager.first(),
      destination: 1
    },
    last: {
      text: l.pager.last(),
      destination: pageCount
    },
    next: {
      text: l.pager.next(),
      destination: currentPage + 1
    },
    previous: {
      text: l.pager.previous(),
      destination: currentPage - 1
    }
  };
  const disabled = useCallback(() => {
    if (currentPage === 1) {
      return type === "previous" || type === "first";
    }
    if (currentPage === pageCount) {
      return type === "next" || type === "last";
    }
    return false;
  }, [pageCount, currentPage, type]);
  useEffect(() => {
    if (disabled() && linkRef.current) {
      linkRef.current.blur();
    }
  }, [disabled]);
  const handleOnClick = ev => {
    onClick?.(ev);
    onPagination?.(navLinkConfig[type].destination, pageSize, type);
  };
  const {
    text
  } = navLinkConfig[type];
  const hideDisabledButtons = hideDisabledElements && disabled();
  return /*#__PURE__*/React.createElement(StyledPagerLink, {
    hideDisabledButtons: hideDisabledButtons,
    "data-element": `pager-link-${type}`,
    disabled: disabled(),
    onClick:
    // Type assertion due to the fact that StyledPagerLink
    // will always return a button element
    handleOnClick,
    ref: linkRef
  }, text);
};
export default PagerNavigationLink;