import React from "react";
interface PagerNavigationLinkProps {
    /** Type of Pagination link to be allowed for navigation */
    type: "next" | "previous" | "first" | "last";
    /** Current visible page */
    currentPage: number;
    /** Count of all the pages  */
    pageCount: number;
    /** If true, sets css property visibility: hidden on all disabled elements  */
    hideDisabledElements?: boolean;
    /** Pagination page size */
    pageSize: number;
    /** onClick Callback function */
    onClick?: (ev: React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLButtonElement>) => void;
    /** onPagination Callback to process pagination  */
    onPagination?: (pageSize: number, currentPage: number, origin: string) => void;
}
declare const PagerNavigationLink: ({ type, currentPage, pageCount, hideDisabledElements, pageSize, onClick, onPagination, }: PagerNavigationLinkProps) => React.JSX.Element;
export default PagerNavigationLink;
