function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useState, useEffect, useRef, useMemo } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import { filterStyledSystemMarginProps } from "../../style/utils";
import Events from "../../__internal__/utils/helpers/events";
import { StyledNumeralDate, StyledDateField } from "./numeral-date.style";
import Textbox from "../textbox";
import Box from "../box";
import Typography from "../typography";
import { ErrorBorder, StyledHintText } from "../textbox/textbox.style";
import ValidationMessage from "../../__internal__/validation-message";
import guid from "../../__internal__/utils/helpers/guid";
import useLocale from "../../hooks/__internal__/useLocale";
import FormField from "../../__internal__/form-field";
import { InputGroupBehaviour } from "../../__internal__/input-behaviour";
import { TooltipProvider } from "../../__internal__/tooltip-provider";
import { NewValidationContext } from "../carbon-provider/carbon-provider.component";
import NumeralDateContext from "./numeral-date-context";
import FormSpacingProvider from "../../__internal__/form-spacing-provider";
import Logger from "../../__internal__/utils/logger";
let deprecateUncontrolledWarnTriggered = false;
export const ALLOWED_DATE_FORMATS = [["dd", "mm", "yyyy"], ["mm", "dd", "yyyy"], ["yyyy", "mm", "dd"], ["dd", "mm"], ["mm", "dd"], ["mm", "yyyy"]];
const incorrectDateFormatMessage = "Forbidden prop dateFormat supplied to NumeralDate. " + "Only one of these date formats is allowed: " + "['dd', 'mm', 'yyyy'], " + "['mm', 'dd', 'yyyy'], " + "['yyyy', 'mm', 'dd'], " + "['dd', 'mm'], " + "['mm', 'dd'], " + "['mm', 'yyyy']";
const getMonthsForLocale = localeName => {
  const year = new Date().getFullYear();
  const {
    format
  } = new Intl.DateTimeFormat(localeName, {
    month: "long"
  });
  return [...Array(12).keys()].map(m => format(new Date(Date.UTC(year, m))));
};
const validationMessages = (locale, month, daysInMonth) => ({
  dd: locale.numeralDate.validation.day(month ? getMonthsForLocale(locale.locale())[+month - 1] : undefined, daysInMonth),
  mm: locale.numeralDate.validation.month(),
  yyyy: locale.numeralDate.validation.year()
});
const getDaysInMonth = (month, year) => {
  if (!month || +month > 12 || +month < 1) {
    return 31;
  }
  const currentDate = new Date();
  const computedYear = +(year || currentDate.getFullYear());

  // passing 0 as the third argument ensures we handle for months being 0 indexed
  return new Date(computedYear, +month, 0).getDate();
};
const validate = (locale, {
  dd,
  mm,
  yyyy
}) => {
  const failed = {
    dd: "",
    mm: "",
    yyyy: ""
  };
  const daysInMonth = getDaysInMonth(mm, yyyy);
  if (dd && (+dd > daysInMonth || +dd < 1)) {
    failed.dd = validationMessages(locale, mm, String(daysInMonth)).dd;
  }
  if (mm && (+mm > 12 || +mm < 1)) {
    failed.mm = validationMessages(locale).mm;
  }
  if (yyyy && (+yyyy < 1800 || +yyyy > 2200)) {
    failed.yyyy = validationMessages(locale).yyyy;
  }
  return failed;
};
const getDateLabel = (datePart, locale) => {
  switch (datePart) {
    case "mm":
      return locale.numeralDate.labels.month();
    case "yyyy":
      return locale.numeralDate.labels.year();
    default:
      return locale.numeralDate.labels.day();
  }
};
export const NumeralDate = ({
  dateFormat = ["dd", "mm", "yyyy"],
  defaultValue,
  disabled,
  error = "",
  warning = "",
  "data-component": dataComponent,
  "data-element": dataElement,
  "data-role": dataRole,
  info,
  id,
  name,
  onBlur,
  onChange,
  value,
  validationOnLabel = false,
  label,
  labelInline,
  labelWidth,
  labelAlign,
  labelHelp,
  labelSpacing,
  fieldHelp,
  adaptiveLabelBreakpoint,
  required,
  isOptional,
  readOnly,
  size,
  enableInternalError,
  enableInternalWarning,
  tooltipPosition,
  helpAriaLabel,
  dayRef,
  monthRef,
  yearRef,
  ...rest
}) => {
  const locale = useLocale();
  const {
    validationRedesignOptIn
  } = useContext(NewValidationContext);
  const {
    current: uniqueId
  } = useRef(id || guid());
  const isControlled = useRef(value !== undefined);
  const initialValue = isControlled.current ? value : defaultValue;
  const refs = useRef(dateFormat.map(() => null));
  const labelIds = useRef([guid(), guid(), guid()]);
  const [internalMessages, setInternalMessages] = useState({
    ...Object.fromEntries(dateFormat.map(datePart => [datePart, ""]))
  });
  const hasCorrectDateFormat = useMemo(() => {
    const isAllowed = !dateFormat || ALLOWED_DATE_FORMATS.find(allowedDateFormat => JSON.stringify(allowedDateFormat) === JSON.stringify(dateFormat));
    return isAllowed;
  }, [dateFormat]);
  !hasCorrectDateFormat ? process.env.NODE_ENV !== "production" ? invariant(false, incorrectDateFormatMessage) : invariant(false) : void 0;
  useEffect(() => {
    const modeSwitchedMessage = "Input elements should not switch from uncontrolled to controlled (or vice versa). " + "Decide between using a controlled or uncontrolled input element for the lifetime of the component";
    !(isControlled.current === (value !== undefined)) ? process.env.NODE_ENV !== "production" ? invariant(false, modeSwitchedMessage) : invariant(false) : void 0;
  }, [value]);
  const [dateValue, setDateValue] = useState({
    ...(initialValue || Object.fromEntries(dateFormat.map(datePart => [datePart, ""])))
  });
  const createCustomEventObject = newValue => ({
    target: {
      name,
      id: uniqueId,
      value: newValue
    }
  });
  const onKeyDown = event => {
    const isValidKey = Events.isNumberKey(event) || Events.isTabKey(event) || event.key === "Delete" || event.key === "Backspace";
    if (!isValidKey) {
      event.preventDefault();
    }
  };
  const handleChange = (event, datePart) => {
    const {
      value: newValue
    } = event.target;
    if (newValue.length <= datePart.length) {
      const newDateValue = {
        ...dateValue,
        [datePart]: newValue
      };
      setDateValue(newDateValue);

      /* istanbul ignore else */
      if (onChange) {
        onChange(createCustomEventObject(newDateValue));
      }
    }
  };
  const handleBlur = () => {
    const internalValidationEnabled = enableInternalError || enableInternalWarning;
    /* istanbul ignore else */
    if (internalValidationEnabled) {
      setInternalMessages(prev => ({
        ...prev,
        ...validate(locale, dateValue)
      }));
    }
    setTimeout(() => {
      const hasBlurred = !refs.current.find(ref => ref === document.activeElement);
      /* istanbul ignore else */
      if (onBlur && hasBlurred) {
        onBlur(createCustomEventObject(dateValue));
      }
    }, 5);
  };
  const internalMessage = Object.keys(internalMessages).reduce((combinedMessage, datePart) => internalMessages[datePart] ? `${combinedMessage + internalMessages[datePart]}\n` : combinedMessage, "");
  const internalError = enableInternalError ? internalMessage + error : error;
  const internalWarning = enableInternalWarning ? internalMessage + warning : warning;
  if (!deprecateUncontrolledWarnTriggered && !isControlled.current) {
    deprecateUncontrolledWarnTriggered = true;
    Logger.deprecate("Uncontrolled behaviour in `Numeral Date` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  return /*#__PURE__*/React.createElement(TooltipProvider, {
    helpAriaLabel: helpAriaLabel
  }, /*#__PURE__*/React.createElement(InputGroupBehaviour, null, /*#__PURE__*/React.createElement(FormField, _extends({
    "data-component": dataComponent,
    "data-element": dataElement,
    "data-role": dataRole,
    disabled: disabled,
    useValidationIcon: validationOnLabel,
    id: uniqueId,
    error: internalError,
    warning: internalWarning,
    info: info,
    label: label,
    labelInline: labelInline,
    labelWidth: labelWidth,
    labelAlign: labelAlign,
    labelHelp: !validationRedesignOptIn && labelHelp,
    labelSpacing: labelSpacing,
    fieldHelp: fieldHelp,
    adaptiveLabelBreakpoint: adaptiveLabelBreakpoint,
    isRequired: required,
    isOptional: isOptional,
    validationRedesignOptIn: validationRedesignOptIn
  }, filterStyledSystemMarginProps(rest)), validationRedesignOptIn && labelHelp && /*#__PURE__*/React.createElement(StyledHintText, null, labelHelp), /*#__PURE__*/React.createElement(Box, {
    position: "relative"
  }, validationRedesignOptIn && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(ValidationMessage, {
    error: internalError,
    warning: internalWarning
  }), (internalError || internalWarning) && /*#__PURE__*/React.createElement(ErrorBorder, {
    warning: !!(!internalError && internalWarning)
  })), /*#__PURE__*/React.createElement(StyledNumeralDate, {
    name: name,
    onKeyDown: onKeyDown,
    "data-component": "numeral-date"
  }, dateFormat.map((datePart, index) => {
    const isEnd = index === dateFormat.length - 1;
    const labelId = labelIds.current[index];
    const validation = internalError || internalWarning || info;
    const isStringValidation = typeof validation === "string";
    const hasValidationIcon = isStringValidation && !!validation.length;
    let inputRef;
    switch (datePart.slice(0, 2)) {
      case "dd":
        inputRef = dayRef;
        break;
      case "mm":
        inputRef = monthRef;
        break;
      case "yy":
        inputRef = yearRef;
        break;
      /* istanbul ignore next */
      default:
        break;
    }
    return /*#__PURE__*/React.createElement(NumeralDateContext.Provider, {
      value: {
        disableErrorBorder: true
      },
      key: datePart
    }, /*#__PURE__*/React.createElement(StyledDateField, {
      key: datePart,
      isYearInput: datePart.length === 4,
      isEnd: isEnd,
      hasValidationIconInField: hasValidationIcon && !validationOnLabel && !validationRedesignOptIn
    }, /*#__PURE__*/React.createElement(FormSpacingProvider, {
      marginBottom: undefined
    }, /*#__PURE__*/React.createElement(Typography, {
      mb: "4px",
      id: labelId
    }, getDateLabel(datePart, locale)), /*#__PURE__*/React.createElement(Textbox, _extends({}, index === 0 && {
      id: uniqueId
    }, {
      disabled: disabled,
      readOnly: readOnly,
      value: dateValue[datePart],
      onChange: e => handleChange(e, datePart),
      onBlur: handleBlur,
      ref: element => {
        refs.current[index] = element;
        if (!inputRef) {
          return;
        }
        if (typeof inputRef === "function") {
          inputRef(element);
        } else {
          inputRef.current = element;
        }
      },
      error: !!internalError,
      warning: !!internalWarning,
      info: !!info
    }, isEnd && !validationRedesignOptIn && !validationOnLabel && {
      error: internalError,
      warning: internalWarning,
      info
    }, {
      size: size,
      tooltipPosition: tooltipPosition,
      "aria-labelledby": labelId,
      required: required
    })))));
  }))))));
};
export default NumeralDate;