import React from "react";
import { MarginProps } from "styled-system";
import { ValidationProps } from "../../__internal__/validations";
export declare const ALLOWED_DATE_FORMATS: readonly [readonly ["dd", "mm", "yyyy"], readonly ["mm", "dd", "yyyy"], readonly ["yyyy", "mm", "dd"], readonly ["dd", "mm"], readonly ["mm", "dd"], readonly ["mm", "yyyy"]];
export interface DayMonthDate {
    dd: string;
    mm: string;
}
export interface MonthYearDate {
    mm: string;
    yyyy: string;
}
export interface FullDate extends DayMonthDate {
    yyyy: string;
}
export declare type NumeralDateObject = DayMonthDate | MonthYearDate | FullDate;
export interface NumeralDateEvent<DateType extends NumeralDateObject = FullDate> {
    target: {
        name?: string;
        id: string;
        value: DateType;
    };
}
export interface NumeralDateProps<DateType extends NumeralDateObject = FullDate> extends ValidationProps, MarginProps {
    /** Breakpoint for adaptive label (inline labels change to top aligned). Enables the adaptive behaviour when set */
    adaptiveLabelBreakpoint?: number;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-component"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-element"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-role"?: string;
    /** If true, the component will be disabled */
    disabled?: boolean;
    /** If true, the component will be read-only */
    readOnly?: boolean;
    dateFormat?: ValidDateFormat;
    /** Default value for use in uncontrolled mode  */
    defaultValue?: DateType;
    /**  Value for use in controlled mode  */
    value?: DateType;
    /** When true, enables the internal errors to be displayed */
    enableInternalError?: boolean;
    /** When true, enables the internal warnings to be displayed */
    enableInternalWarning?: boolean;
    /** Help content to be displayed under an input */
    fieldHelp?: React.ReactNode;
    /** `id` for events */
    id?: string;
    /** `name` for events */
    name?: string;
    /** Label */
    label?: string;
    /** Label alignment. Works only when labelInline is true */
    labelAlign?: "left" | "right";
    /** Text applied to label help tooltip */
    labelHelp?: React.ReactNode;
    /** When true, label is placed in line with an input */
    labelInline?: boolean;
    /** Label width */
    labelWidth?: number;
    /** Spacing between label and a field for inline label, given number will be multiplied by base spacing unit (8) */
    labelSpacing?: 1 | 2;
    /** Blur event handler */
    onBlur?: (ev: NumeralDateEvent<DateType>) => void;
    /** Change event handler */
    onChange?: (ev: NumeralDateEvent<DateType>) => void;
    /** Flag to configure component as mandatory */
    required?: boolean;
    /** Size of an input */
    size?: "small" | "medium" | "large";
    /** When true, validation icons will be placed on labels instead of being placed on the inputs */
    validationOnLabel?: boolean;
    /** Overrides the default tooltip position */
    tooltipPosition?: "top" | "bottom" | "left" | "right";
    /** Aria label for rendered help component */
    helpAriaLabel?: string;
    /**
     * A React ref to pass to the input corresponding to the day
     */
    dayRef?: React.ForwardedRef<HTMLInputElement>;
    /**
     * A React ref to pass to the input corresponding to the month
     */
    monthRef?: React.ForwardedRef<HTMLInputElement>;
    /**
     * A React ref to pass to the input corresponding to the year
     */
    yearRef?: React.ForwardedRef<HTMLInputElement>;
    /** Flag to configure component as optional. */
    isOptional?: boolean;
}
export declare type ValidDateFormat = typeof ALLOWED_DATE_FORMATS[number];
export declare const NumeralDate: <DateType extends NumeralDateObject = FullDate>({ dateFormat, defaultValue, disabled, error, warning, "data-component": dataComponent, "data-element": dataElement, "data-role": dataRole, info, id, name, onBlur, onChange, value, validationOnLabel, label, labelInline, labelWidth, labelAlign, labelHelp, labelSpacing, fieldHelp, adaptiveLabelBreakpoint, required, isOptional, readOnly, size, enableInternalError, enableInternalWarning, tooltipPosition, helpAriaLabel, dayRef, monthRef, yearRef, ...rest }: NumeralDateProps<DateType>) => React.JSX.Element;
export default NumeralDate;
