function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import { Editor } from "draft-js";
import invariant from "invariant";
import { StyledNote, StyledNoteContent, StyledNoteMain, StyledInlineControl, StyledTitle, StyledFooter, StyledFooterContent } from "./note.style";
import StatusIcon from "./__internal__/status-icon";
import { ActionPopover } from "../action-popover";
import { getDecoratedValue } from "../text-editor/__internal__/utils";
import { EditorContext } from "../text-editor/text-editor.component";
import LinkPreview from "../link-preview";
function hasExpectedDisplayName(child, displayName) {
  return child.type.displayName === displayName;
}
export const Note = ({
  createdDate,
  inlineControl,
  name,
  noteContent,
  onLinkAdded,
  previews,
  status,
  title,
  width = 100,
  ...rest
}) => {
  !(width > 0) ? process.env.NODE_ENV !== "production" ? invariant(false, "<Note> width must be greater than 0") : invariant(false) : void 0;
  !createdDate ? process.env.NODE_ENV !== "production" ? invariant(false, "<Note> createdDate is required") : invariant(false) : void 0;
  !noteContent ? process.env.NODE_ENV !== "production" ? invariant(false, "<Note> noteContent is required") : invariant(false) : void 0;
  !(!status || status.text) ? process.env.NODE_ENV !== "production" ? invariant(false, "<Note> status.text is required") : invariant(false) : void 0;
  !(!status || status.timeStamp) ? process.env.NODE_ENV !== "production" ? invariant(false, "<Note> status.timeStamp is required") : invariant(false) : void 0;
  !(!inlineControl || /*#__PURE__*/React.isValidElement(inlineControl) && inlineControl.type === ActionPopover) ? process.env.NODE_ENV !== "production" ? invariant(false, "<Note> inlineControl must be an instance of <ActionPopover>") : invariant(false) : void 0;
  const renderStatus = () => {
    if (!status) {
      return null;
    }
    const {
      text,
      timeStamp
    } = status;
    return /*#__PURE__*/React.createElement(StyledFooterContent, {
      hasName: !!name,
      "data-component": "note-status"
    }, /*#__PURE__*/React.createElement(StatusIcon, {
      tooltipMessage: timeStamp
    }, text));
  };
  return /*#__PURE__*/React.createElement(EditorContext.Provider, {
    value: {
      onLinkAdded,
      editMode: false
    }
  }, /*#__PURE__*/React.createElement(StyledNote, _extends({
    width: width
  }, rest, {
    "data-component": "note"
  }), /*#__PURE__*/React.createElement(StyledNoteMain, null, /*#__PURE__*/React.createElement(StyledNoteContent, null, title && /*#__PURE__*/React.createElement(StyledTitle, null, title), /*#__PURE__*/React.createElement(Editor, {
    readOnly: true,
    editorState: getDecoratedValue(noteContent),
    onChange: /* istanbul ignore next */() => {}
  })), inlineControl && /*#__PURE__*/React.createElement(StyledInlineControl, null, inlineControl)), /*#__PURE__*/React.createElement(StyledNoteContent, null, React.Children.map(previews, preview => /*#__PURE__*/React.isValidElement(preview) && hasExpectedDisplayName(preview, LinkPreview.displayName) ? /*#__PURE__*/React.cloneElement(preview, {
    as: "a",
    onClose: undefined
  }) : preview)), createdDate && /*#__PURE__*/React.createElement(StyledNoteContent, {
    hasPreview: !!React.Children.count(previews)
  }, /*#__PURE__*/React.createElement(StyledFooter, {
    "data-element": "note-footer"
  }, name && /*#__PURE__*/React.createElement(StyledFooterContent, {
    hasName: !!name
  }, name), /*#__PURE__*/React.createElement(StyledFooterContent, {
    hasName: !!name
  }, createdDate), renderStatus()))));
};
export default Note;