import React from "react";
import PropTypes from "prop-types";
import StyledStatusIconWrapper from "./status-icon.style";
import Tooltip from "../../../tooltip";
const StatusIcon = /*#__PURE__*/React.forwardRef(({
  tooltipMessage,
  children
}, ref) => {
  return /*#__PURE__*/React.createElement(Tooltip, {
    message: tooltipMessage
  }, /*#__PURE__*/React.createElement(StyledStatusIconWrapper, {
    "data-component": "status-with-tooltip",
    ref: ref
  }, children));
});
if (process.env.NODE_ENV !== "production") {
  StatusIcon.propTypes = {
    "children": PropTypes.node,
    "tooltipMessage": PropTypes.string.isRequired
  };
}
StatusIcon.displayName = "StatusIcon";
export default StatusIcon;