import { PaddingProps, FlexboxProps } from "styled-system";
import { Position, Orientation, NavigationType } from "./navigation-bar.component";
export declare type StyledNavigationBarProps = PaddingProps & FlexboxProps & {
    /** Color scheme of navigation component */
    navigationType?: NavigationType;
    /** Defines whether the navigation bar should be positioned fixed or sticky */
    position?: Position;
    /** Defines the offset of navigation bar */
    offset?: string;
    /** Defines whether the navigation bar should be positioned top or bottom */
    orientation?: Orientation;
    /** set to true only when rendering the GlobalHeader component */
    isGlobal?: boolean;
};
declare const StyledNavigationBar: import("styled-components").StyledComponent<"nav", any, PaddingProps<Required<import("styled-system").Theme<import("styled-system").TLengthStyledSystem>>> & FlexboxProps<Required<import("styled-system").Theme<import("styled-system").TLengthStyledSystem>>> & {
    /** Color scheme of navigation component */
    navigationType?: NavigationType | undefined;
    /** Defines whether the navigation bar should be positioned fixed or sticky */
    position?: Position | undefined;
    /** Defines the offset of navigation bar */
    offset?: string | undefined;
    /** Defines whether the navigation bar should be positioned top or bottom */
    orientation?: Orientation | undefined;
    /** set to true only when rendering the GlobalHeader component */
    isGlobal?: boolean | undefined;
}, never>;
export default StyledNavigationBar;
