import React from "react";
import { PaddingProps, FlexboxProps } from "styled-system";
export declare type Position = "sticky" | "fixed";
export declare type Orientation = "top" | "bottom";
export declare type NavigationType = "light" | "dark" | "white" | "black";
export interface NavigationBarProps extends PaddingProps, FlexboxProps {
    /** Content of the component */
    children?: React.ReactNode;
    /** HTML aria-label attribute */
    ariaLabel?: string;
    /** Color scheme of navigation component */
    navigationType?: NavigationType;
    /** If 'true' the children will not be visible */
    isLoading?: boolean;
    /** Defines whether the navigation bar should be positioned fixed or sticky */
    position?: Position;
    /** Defines the offset of navigation bar */
    offset?: string;
    /** Defines whether the navigation bar should be positioned top or bottom */
    orientation?: Orientation;
    /** @private @ignore set to true only when rendering the GlobalHeader component */
    isGlobal?: boolean;
}
export declare const NavigationBar: ({ navigationType, isLoading, children, ariaLabel, position, offset, orientation, isGlobal, ...props }: NavigationBarProps) => JSX.Element;
export default NavigationBar;
