import React, { createContext, useState, useCallback, useEffect } from "react";
import useResizeObserver from "../../hooks/__internal__/useResizeObserver/useResizeObserver";
const FixedNavigationBarContext = /*#__PURE__*/createContext({});
export const FixedNavigationBarContextProvider = ({
  position,
  orientation,
  offset,
  children,
  navbarRef
}) => {
  const [navbarHeight, setNavbarHeight] = useState(navbarRef.current?.offsetHeight);
  const updateHeight = useCallback(() => setNavbarHeight(navbarRef.current?.offsetHeight), [navbarRef]);
  useEffect(() => {
    updateHeight();
  }, [updateHeight]);
  useResizeObserver(navbarRef, updateHeight);
  let submenuMaxHeight;
  if (position === "fixed") {
    if (orientation === "top" && navbarHeight !== undefined) {
      submenuMaxHeight = `calc(100vh - ${navbarHeight}px - ${offset})`;
    } else if (orientation === "bottom") {
      submenuMaxHeight = offset;
    }
  }
  return /*#__PURE__*/React.createElement(FixedNavigationBarContext.Provider, {
    value: {
      submenuMaxHeight
    }
  }, children);
};
export default FixedNavigationBarContext;