function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef } from "react";
import PropTypes from "prop-types";
import { flip, offset } from "@floating-ui/dom";
import useClickAwayListener from "../../hooks/__internal__/useClickAwayListener";
import SplitButtonContext from "../split-button/__internal__/split-button.context";
import { StyledMultiActionButton, StyledButtonChildrenContainer } from "./multi-action-button.style";
import Button from "../button";
import Popover from "../../__internal__/popover";
import { filterStyledSystemMarginProps, filterOutStyledSystemSpacingProps } from "../../style/utils";
import useChildButtons from "../../hooks/__internal__/useChildButtons";
export const MultiActionButton = ({
  align = "left",
  disabled,
  buttonType,
  size,
  children,
  text,
  subtext,
  width,
  onClick,
  "data-element": dataElement,
  "data-role": dataRole,
  ...rest
}) => {
  const buttonRef = useRef(null);
  const {
    showAdditionalButtons,
    showButtons,
    hideButtons,
    buttonNode,
    handleToggleButtonKeyDown,
    wrapperProps,
    contextValue
  } = useChildButtons(buttonRef);
  const handleInsideClick = useClickAwayListener(hideButtons);
  const handleClick = ev => {
    showButtons();
    handleInsideClick();
    if (onClick) {
      onClick(ev);
    }
  };
  const mainButtonProps = {
    disabled,
    displayed: showAdditionalButtons,
    onTouchStart: showButtons,
    onKeyDown: handleToggleButtonKeyDown,
    onClick: handleClick,
    buttonType,
    size,
    subtext,
    ...filterOutStyledSystemSpacingProps(rest)
  };
  const renderAdditionalButtons = () => /*#__PURE__*/React.createElement(Popover, {
    placement: "bottom-end",
    reference: buttonNode,
    middleware: [offset(6), flip({
      fallbackStrategy: "initialPlacement"
    })]
  }, /*#__PURE__*/React.createElement(StyledButtonChildrenContainer, _extends({}, wrapperProps, {
    align: align
  }), /*#__PURE__*/React.createElement(SplitButtonContext.Provider, {
    value: contextValue
  }, React.Children.map(children, child => /*#__PURE__*/React.createElement("li", null, child)))));
  const marginProps = filterStyledSystemMarginProps(rest);
  return /*#__PURE__*/React.createElement(StyledMultiActionButton, _extends({
    ref: buttonNode,
    "data-component": "multi-action-button",
    "data-element": dataElement,
    "data-role": dataRole,
    displayed: showAdditionalButtons,
    width: width
  }, marginProps), /*#__PURE__*/React.createElement(Button, _extends({
    "aria-haspopup": "true",
    "aria-expanded": showAdditionalButtons,
    "data-element": "toggle-button",
    key: "toggle-button"
  }, mainButtonProps, {
    ref: buttonRef,
    iconPosition: "after",
    iconType: "dropdown"
  }), text), showAdditionalButtons && renderAdditionalButtons());
};
export default MultiActionButton;