import React from "react";
import { WidthProps } from "styled-system";
import { SplitButtonProps } from "../split-button";
export interface MultiActionButtonProps extends WidthProps, Omit<SplitButtonProps, "buttonType" | "iconPosition" | "iconType"> {
    /** Button type: "primary" | "secondary" | "tertiary" */
    buttonType?: "primary" | "secondary" | "tertiary";
    /** Second text child, renders under main text, only when size is "large" */
    subtext?: string;
}
export declare const MultiActionButton: ({ align, disabled, buttonType, size, children, text, subtext, width, onClick, "data-element": dataElement, "data-role": dataRole, ...rest }: MultiActionButtonProps) => React.JSX.Element;
export default MultiActionButton;
