function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useEffect, useRef, useCallback, useState } from "react";
import PropTypes from "prop-types";
import { TransitionGroup, CSSTransition } from "react-transition-group";
import useScrollBlock from "../../hooks/__internal__/useScrollBlock";
import Portal from "../portal";
import Events from "../../__internal__/utils/helpers/events";
import useModalManager from "../../hooks/__internal__/useModalManager";
import { StyledModal, StyledModalBackground } from "./modal.style";
export const ModalContext = /*#__PURE__*/React.createContext({});
const Modal = ({
  children,
  open,
  onCancel,
  disableEscKey = false,
  disableClose,
  enableBackgroundUI = false,
  timeout = 300,
  topModalOverride,
  ...rest
}) => {
  const ref = useRef(null);
  const backgroundNodeRef = useRef(null);
  const contentNodeRef = useRef(null);
  const [isAnimationComplete, setAnimationComplete] = useState(false);
  const [triggerRefocusFlag, setTriggerRefocusFlag] = useState(false);
  const {
    blockScroll,
    allowScroll
  } = useScrollBlock();
  useEffect(() => {
    if (enableBackgroundUI) {
      return;
    }
    if (open) {
      blockScroll();
    } else {
      allowScroll();
    }
  }, [allowScroll, blockScroll, enableBackgroundUI, open]);
  useEffect(() => {
    return () => {
      if (!enableBackgroundUI) {
        allowScroll();
      }
    };
  }, [allowScroll, enableBackgroundUI]);
  const closeModal = useCallback(ev => {
    if (onCancel && !disableClose && !disableEscKey && Events.isEscKey(ev)) {
      ev.stopImmediatePropagation();
      onCancel(ev);
    }
  }, [disableClose, disableEscKey, onCancel]);
  useModalManager({
    open,
    closeModal,
    modalRef: ref,
    setTriggerRefocusFlag,
    topModalOverride
  });
  let background;
  let content;
  if (open) {
    background = !enableBackgroundUI ? /*#__PURE__*/React.createElement(StyledModalBackground, {
      ref: backgroundNodeRef,
      "data-element": "modal-background",
      transitionName: "modal-background",
      transitionTime: timeout
    }) : null;
    content = children;
  }
  return /*#__PURE__*/React.createElement(Portal, null, /*#__PURE__*/React.createElement(StyledModal, _extends({
    "data-state": open ? "open" : "closed",
    transitionName: "modal",
    transitionTime: timeout,
    topModalOverride: topModalOverride,
    ref: ref
  }, rest), /*#__PURE__*/React.createElement(TransitionGroup, null, background && /*#__PURE__*/React.createElement(CSSTransition, {
    nodeRef: backgroundNodeRef,
    key: "modal",
    appear: true,
    classNames: "modal-background",
    timeout: timeout,
    onEntered: () => setAnimationComplete(true),
    onExiting: () => setAnimationComplete(false)
  }, background)), /*#__PURE__*/React.createElement(TransitionGroup, null, content && /*#__PURE__*/React.createElement(CSSTransition, {
    nodeRef: contentNodeRef,
    appear: true,
    classNames: "modal",
    timeout: timeout
  }, /*#__PURE__*/React.createElement(ModalContext.Provider, {
    value: {
      isAnimationComplete,
      triggerRefocusFlag,
      isInModal: true
    }
  }, /*#__PURE__*/React.createElement("div", {
    ref: contentNodeRef
  }, content))))));
};
export default Modal;