function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
let ModalManagerInstance = /*#__PURE__*/function () {
  function ModalManagerInstance() {
    _classCallCheck(this, ModalManagerInstance);
    _defineProperty(this, "modalList", void 0);
    _defineProperty(this, "addModal", (modal, setTriggerRefocusFlag, topModalOverride) => {
      if (!modal) {
        return;
      }
      const {
        modal: topModal,
        setTriggerRefocusFlag: setTrapFlag,
        topModalOverride: topOverridden
      } = this.getTopModal();
      if (!topOverridden && topModal && setTrapFlag) {
        setTrapFlag(false);
      }
      this.modalList.push({
        modal,
        setTriggerRefocusFlag,
        topModalOverride
      });
      this.callTopModalSetters();
    });
    // Due to possibility of multiple carbon versions using it
    // it is necessary to maintain same structure in this global variable
    if (!window.__CARBON_INTERNALS_MODAL_LIST) {
      window.__CARBON_INTERNALS_MODAL_LIST = [];
    }
    this.modalList = window.__CARBON_INTERNALS_MODAL_LIST;
  }
  return _createClass(ModalManagerInstance, [{
    key: "getTopModal",
    value: function getTopModal() {
      if (!this.modalList.length) {
        return {};
      }
      const topModalOverride = this.modalList.slice().reverse().find(modal => modal.topModalOverride);
      return topModalOverride || this.modalList[this.modalList.length - 1];
    }
  }, {
    key: "isTopmost",
    value: function isTopmost(modal) {
      const {
        modal: topModal
      } = this.getTopModal();
      if (!modal || !topModal) {
        return false;
      }
      return modal === topModal;
    }
  }, {
    key: "removeModal",
    value: function removeModal(modal, triggerRefocusOnClose = true) {
      const modalIndex = this.modalList.findIndex(({
        modal: m
      }) => m === modal);
      if (modalIndex === -1) {
        return;
      }
      this.modalList.splice(modalIndex, 1);
      this.callTopModalSetters();
      if (!this.modalList.length) {
        return;
      }
      const {
        setTriggerRefocusFlag
      } = this.getTopModal();
      if (setTriggerRefocusFlag && triggerRefocusOnClose) {
        setTriggerRefocusFlag(true);
      }
    }
  }, {
    key: "clearList",
    value: function clearList() {
      window.__CARBON_INTERNALS_MODAL_LIST = [];
      this.modalList = window.__CARBON_INTERNALS_MODAL_LIST;
      this.callTopModalSetters();
    }
  }, {
    key: "callTopModalSetters",
    value: function callTopModalSetters() {
      if (window.__CARBON_INTERNALS_MODAL_SETTER_LIST) {
        const topModal = this.getTopModal()?.modal || null;
        for (const setTopModal of window.__CARBON_INTERNALS_MODAL_SETTER_LIST) {
          setTopModal(topModal);
        }
      }
    }
  }]);
}();
const ModalManager = new ModalManagerInstance();
export { ModalManagerInstance };
export default ModalManager;