import React from "react";
import PropTypes from "prop-types";
import TypeIconStyle from "./type-icon.style";
import Icon from "../../icon";
const TypeIcon = ({
  variant = "info",
  transparent = false
}) => {
  function iconToRender() {
    if (variant === "neutral") return "info";
    if (variant === "success") return "tick_circle";
    return variant;
  }
  return /*#__PURE__*/React.createElement(TypeIconStyle, {
    variant: variant,
    transparent: transparent
  }, /*#__PURE__*/React.createElement(Icon, {
    type: iconToRender()
  }));
};
export default TypeIcon;