import React from "react";
import { MarginProps } from "styled-system";
export declare type MessageVariant = "error" | "info" | "success" | "warning" | "neutral";
export interface MessageProps extends MarginProps {
    /** set content to component */
    children?: React.ReactNode;
    /** set custom class to component */
    className?: string;
    /** set custom aria label for message close button */
    closeButtonAriaLabel?: string;
    /** set custom id to component root */
    id?: string;
    /** function runs when user click dismiss button */
    onDismiss?: (e: React.KeyboardEvent<HTMLButtonElement> | React.MouseEvent<HTMLButtonElement>) => void;
    /** show message component */
    open?: boolean;
    /** determines if the close icon is shown */
    showCloseIcon?: boolean;
    /** set message title */
    title?: React.ReactNode;
    /** set background to be invisible */
    transparent?: boolean;
    /** set type of message based on new DLS standard */
    variant?: MessageVariant;
}
export declare const Message: React.ForwardRefExoticComponent<MessageProps & React.RefAttributes<HTMLDivElement>>;
export default Message;
