import React from "react";
import PropTypes from "prop-types";
import Content from "../../content";
import MessageContentStyle from "./message-content.style";
const MessageContent = ({
  title,
  children,
  showCloseIcon,
  reduceLeftPadding = false
}) => {
  return /*#__PURE__*/React.createElement(MessageContentStyle, {
    showCloseIcon: showCloseIcon,
    reduceLeftPadding: reduceLeftPadding,
    "data-element": "message-content"
  }, /*#__PURE__*/React.createElement(Content, {
    title: title
  }, children));
};
export default MessageContent;