function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext } from "react";
import PropTypes from "prop-types";
import MenuContext from "../menu.context";
import MenuItem from "../menu-item";
import StyledScrollableBlock from "./scrollable-block.style";
import Box from "../../box";
import tagComponent from "../../../__internal__/utils/helpers/tags";
export const ScrollableBlock = ({
  children,
  height,
  variant = "default",
  parent,
  parentVariant,
  ...rest
}) => {
  const {
    menuType
  } = useContext(MenuContext);
  const scrollVariants = {
    light: "light",
    dark: "dark",
    white: "light",
    black: "dark"
  };
  return /*#__PURE__*/React.createElement(StyledScrollableBlock, _extends({}, tagComponent("submenu-scrollable-block", rest), {
    menuType: menuType,
    variant: variant
  }, rest), parent && /*#__PURE__*/React.createElement(MenuItem, {
    "data-component": "scrollable-block-parent",
    overrideColor: true,
    variant: parentVariant,
    p: "2px 16px",
    as: "div"
  }, parent), /*#__PURE__*/React.createElement(Box, {
    overflowY: "scroll",
    scrollVariant: scrollVariants[menuType],
    height: height,
    p: 0,
    as: "ul",
    role: "list"
  }, children));
};
export default ScrollableBlock;