import React from "react";
import { VariantType } from "../menu-item";
import { TagProps } from "../../../__internal__/utils/helpers/tags";
export interface ScrollableBlockProps extends TagProps {
    /** Children elements */
    children: React.ReactNode;
    /** A custom height to be applied to the component. */
    height?: string | number;
    /** set the colour variant for a menuType */
    variant?: VariantType;
    /** the element, if any, displayed at the top of the block to be its semantic "parent",
     * but not part of the scrollable section
     */
    parent?: React.ReactElement;
    /** the colour variant for the parent element, if different from the variant of the block */
    parentVariant?: VariantType;
}
export declare const ScrollableBlock: ({ children, height, variant, parent, parentVariant, ...rest }: ScrollableBlockProps) => React.JSX.Element;
export default ScrollableBlock;
