function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useState, useRef } from "react";
import PropTypes from "prop-types";
import { StyledMenuWrapper } from "./menu.style";
import tagComponent from "../../__internal__/utils/helpers/tags";
import MenuContext from "./menu.context";
import { menuKeyboardNavigation } from "./__internal__/keyboard-navigation";
import { MENU_ITEM_CHILDREN_LOCATOR } from "./__internal__/locators";
export const Menu = ({
  menuType = "light",
  children,
  ...rest
}) => {
  const [openSubmenuId, setOpenSubmenuId] = useState(null);
  const ref = useRef(null);
  const [focusId, setFocusId] = useState(undefined);
  const [itemIds, setItemIds] = useState([]);
  const registerItem = useCallback(id => {
    setItemIds(prevState => {
      return [...prevState, id];
    });
  }, []);
  const unregisterItem = useCallback(id => {
    setItemIds(prevState => {
      return prevState.filter(itemId => itemId !== id);
    });
  }, []);
  const handleKeyDown = event => {
    /* istanbul ignore else */
    if (ref.current) {
      const focusableItems = ref.current.querySelectorAll(MENU_ITEM_CHILDREN_LOCATOR);

      /* istanbul ignore else */
      if (focusableItems) {
        const newIndex = menuKeyboardNavigation(event, Array.from(focusableItems));

        /* istanbul ignore else */
        if (newIndex !== undefined) {
          setFocusId(itemIds[newIndex]);
        }
      }
    }
  };
  return /*#__PURE__*/React.createElement(StyledMenuWrapper, _extends({
    menuType: menuType
  }, rest, tagComponent("menu", rest), {
    ref: ref,
    role: "list",
    onKeyDown: handleKeyDown
  }), /*#__PURE__*/React.createElement(MenuContext.Provider, {
    value: {
      menuType,
      inMenu: true,
      openSubmenuId,
      setOpenSubmenuId,
      focusId,
      registerItem,
      unregisterItem
    }
  }, children));
};
export { MenuContext };
export default Menu;