function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext } from "react";
import PropTypes from "prop-types";
import { StyledTitle, StyledSegmentChildren } from "./menu-segment-title.style";
import MenuContext from "../menu.context";
import { StyledMenuItem } from "../menu.style";
import tagComponent from "../../../__internal__/utils/helpers/tags";
const AS_VALUES = ["h2", "h3", "h4", "h5", "h6"];
const MenuSegmentTitle = /*#__PURE__*/React.forwardRef(({
  children,
  variant = "default",
  text,
  as = "h2",
  ...rest
}, ref) => {
  const menuContext = useContext(MenuContext);
  return /*#__PURE__*/React.createElement(StyledMenuItem, {
    inSubmenu: true
  }, /*#__PURE__*/React.createElement(StyledTitle, _extends({
    as: AS_VALUES.includes(as) ? as : /* istanbul ignore next */"h2"
  }, tagComponent("menu-segment-title", rest), {
    menuType: menuContext.menuType,
    ref: ref,
    variant: variant
  }), text), children && /*#__PURE__*/React.createElement(StyledSegmentChildren, null, children));
});
if (process.env.NODE_ENV !== "production") {
  MenuSegmentTitle.propTypes = {
    "as": PropTypes.oneOf(["h2", "h3", "h4", "h5", "h6"]),
    "children": PropTypes.node,
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "text": PropTypes.string.isRequired,
    "variant": PropTypes.oneOf(["alternate", "default"])
  };
}
MenuSegmentTitle.displayName = "MenuSegmentTitle";
export default MenuSegmentTitle;