function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef, useEffect, useCallback, useContext } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import { filterStyledSystemPaddingProps } from "../../../style/utils";
import StyledMenuItemWrapper from "./menu-item.style";
import Events from "../../../__internal__/utils/helpers/events";
import MenuContext from "../menu.context";
import Submenu from "../__internal__/submenu/submenu.component";
import SubmenuContext from "../__internal__/submenu/submenu.context";
import { StyledMenuItem } from "../menu.style";
import guid from "../../../__internal__/utils/helpers/guid";
import tagComponent from "../../../__internal__/utils/helpers/tags";
export const MenuItem = ({
  submenu,
  children,
  href,
  onClick,
  target,
  submenuDirection = "right",
  icon,
  selected,
  onKeyDown,
  variant = "default",
  showDropdownArrow = true,
  ariaLabel,
  clickToOpen,
  maxWidth,
  onSubmenuOpen,
  onSubmenuClose,
  overrideColor,
  rel,
  as,
  ...rest
}) => {
  !(icon || children) ? process.env.NODE_ENV !== "production" ? invariant(false, "Either prop `icon` must be defined or this node must have `children`.") : invariant(false) : void 0;
  !(children || ariaLabel || typeof submenu === "string") ? process.env.NODE_ENV !== "production" ? invariant(false, "If no text is provided an `ariaLabel` should be given to facilitate accessibility.") : invariant(false) : void 0;
  const {
    inFullscreenView,
    registerItem,
    unregisterItem,
    focusId,
    menuType,
    openSubmenuId
  } = useContext(MenuContext);
  const menuItemId = useRef(guid());
  const submenuContext = useContext(SubmenuContext);
  const {
    submenuFocusId,
    updateFocusId: updateSubmenuFocusId,
    handleKeyDown: handleSubmenuKeyDown,
    shiftTabPressed
  } = submenuContext;
  const ref = useRef(null);
  const focusFromMenu = focusId === menuItemId.current;
  const focusFromSubmenu = submenuFocusId ? submenuFocusId === menuItemId.current : undefined;
  const inputRef = useRef(null);
  inputRef.current = ref.current ? ref.current.querySelector("[data-element='input']") : null;
  const focusRef = inputRef.current ? inputRef : ref;
  useEffect(() => {
    const id = menuItemId.current;
    if (registerItem) {
      registerItem(id);
    }
    return () => {
      if (unregisterItem) {
        unregisterItem(id);
      }
    };
  }, [registerItem, unregisterItem]);
  useEffect(() => {
    const inputIcon = ref.current?.querySelector("[data-element='input-icon-toggle']");
    if (!openSubmenuId && focusFromSubmenu === undefined && focusFromMenu) {
      /* istanbul ignore else */
      if (focusRef.current) {
        focusRef.current?.focus();
      }
    } else if (focusFromSubmenu && !(shiftTabPressed && inputIcon?.getAttribute("tabindex") === "0")) {
      /* istanbul ignore else */
      if (focusRef.current) {
        focusRef.current?.focus();
      }
    }
  }, [openSubmenuId, focusFromMenu, focusFromSubmenu, shiftTabPressed, focusRef]);
  const updateFocusOnClick = useCallback(() => {
    if (updateSubmenuFocusId) {
      updateSubmenuFocusId(menuItemId.current);
    }
  }, [updateSubmenuFocusId]);
  const handleKeyDown = useCallback(event => {
    if (onKeyDown) {
      onKeyDown(event);
    }
    if (ref.current && Events.isEscKey(event)) {
      ref.current?.focus();
    }
    const inputIcon = ref.current?.querySelector("[data-element='input-icon-toggle']");
    const shouldFocusIcon = inputIcon?.getAttribute("tabindex") === "0" && document.activeElement === inputRef.current && inputRef.current?.value;

    // let natural tab order move focus if input icon is tabbable or input with button exists
    if (Events.isTabKey(event) && (!Events.isShiftKey(event) && shouldFocusIcon || Events.isShiftKey(event) && document.activeElement === inputIcon)) {
      return;
    }
    if (handleSubmenuKeyDown) {
      handleSubmenuKeyDown(event);
    }
  }, [onKeyDown, handleSubmenuKeyDown]);
  const elementProps = {
    className: href || onClick ? "carbon-menu-item--has-link" : "",
    href,
    target,
    rel,
    onClick,
    icon,
    removeAriaLabelOnIcon: true,
    selected,
    variant,
    onKeyDown: !inFullscreenView ? handleKeyDown : undefined,
    overrideColor,
    ref
  };
  const getTitle = title => maxWidth && typeof title === "string" ? title : undefined;
  const itemMaxWidth = !inFullscreenView ? maxWidth : undefined;
  const asPassiveItem = !(onClick || href);
  const hasInput = !!inputRef.current;
  if (submenu) {
    return /*#__PURE__*/React.createElement(StyledMenuItem, _extends({}, tagComponent("menu-item", rest), {
      menuType: menuType,
      title: getTitle(submenu),
      maxWidth: itemMaxWidth,
      onClick: updateFocusOnClick
    }, rest, {
      inFullscreenView: inFullscreenView,
      id: menuItemId.current,
      as: as
    }), /*#__PURE__*/React.createElement(Submenu, _extends({}, typeof submenu !== "boolean" && {
      title: submenu
    }, {
      submenuDirection: submenuDirection,
      showDropdownArrow: showDropdownArrow,
      clickToOpen: clickToOpen,
      maxWidth: maxWidth,
      asPassiveItem: asPassiveItem,
      ariaLabel: ariaLabel,
      onSubmenuOpen: onSubmenuOpen,
      onSubmenuClose: onSubmenuClose
    }, elementProps, rest), children));
  }
  const paddingProps = filterStyledSystemPaddingProps(rest);
  return /*#__PURE__*/React.createElement(StyledMenuItem, _extends({}, tagComponent("menu-item", rest), {
    menuType: menuType,
    inSubmenu: !!handleSubmenuKeyDown,
    title: getTitle(children),
    maxWidth: itemMaxWidth
  }, rest, {
    inFullscreenView: inFullscreenView && !Object.keys(submenuContext).length,
    id: menuItemId.current,
    onClick: updateFocusOnClick,
    as: as
  }), /*#__PURE__*/React.createElement(StyledMenuItemWrapper, _extends({
    menuType: menuType
  }, elementProps, {
    ariaLabel: ariaLabel,
    maxWidth: maxWidth,
    inFullscreenView: inFullscreenView,
    asPassiveItem: asPassiveItem,
    placeholderTabIndex: asPassiveItem
  }, paddingProps, {
    asDiv: hasInput || as === "div",
    hasInput: hasInput
  }), children));
};
MenuItem.displayName = "MenuItem";
export default MenuItem;