import React, { useCallback, useContext, useRef } from "react";
import PropTypes from "prop-types";
import { CSSTransition } from "react-transition-group";
import { StyledMenuFullscreen, StyledMenuModal, StyledMenuFullscreenHeader } from "./menu-full-screen.style";
import { StyledMenuWrapper } from "../menu.style";
import MenuContext from "../menu.context";
import Events from "../../../__internal__/utils/helpers/events";
import Box from "../../box";
import IconButton from "../../icon-button";
import Icon from "../../icon";
import Portal from "../../portal";
import FocusTrap from "../../../__internal__/focus-trap";
import MenuDivider from "../menu-divider/menu-divider.component";
import useLocale from "../../../hooks/__internal__/useLocale";
import useModalAria from "../../../hooks/__internal__/useModalAria";
import useModalManager from "../../../hooks/__internal__/useModalManager";
export const MenuFullscreen = ({
  "aria-label": ariaLabel = "Fullscreen menu",
  "data-element": dataElement,
  "data-role": dataRole,
  children,
  isOpen = false,
  onClose,
  startPosition = "left",
  topModalOverride
}) => {
  const menuRef = useRef(null);
  const modalRef = useRef(null);
  const contentRef = useRef(null);
  const isTopModal = useModalAria(modalRef);
  const {
    menuType
  } = useContext(MenuContext);
  const isDarkVariant = ["dark", "black"].includes(menuType);
  const transitionDuration = 200;
  const locale = useLocale();
  const flattenedChildren = React.Children.toArray(children);
  const childArray = React.Children.toArray(flattenedChildren.map((child, index) => {
    if (index < flattenedChildren.length - 1) {
      return /*#__PURE__*/React.createElement(React.Fragment, null, child, /*#__PURE__*/React.createElement(MenuDivider, null));
    }
    return child;
  }));
  const closeModal = useCallback(ev => {
    if (onClose && Events.isEscKey(ev)) {
      ev.stopImmediatePropagation();
      onClose(ev);
    }
  }, [onClose]);
  useModalManager({
    open: isOpen,
    closeModal,
    modalRef: menuRef,
    topModalOverride
  });
  return /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(Portal, null, /*#__PURE__*/React.createElement(CSSTransition, {
    nodeRef: menuRef,
    in: isOpen,
    timeout: transitionDuration,
    unmountOnExit: true
  }, /*#__PURE__*/React.createElement(StyledMenuFullscreen, {
    ref: menuRef,
    startPosition: startPosition,
    transitionDuration: transitionDuration
  }, /*#__PURE__*/React.createElement(FocusTrap, {
    wrapperRef: modalRef,
    isOpen: isOpen
  }, /*#__PURE__*/React.createElement(StyledMenuModal, {
    "aria-label": ariaLabel,
    "aria-modal": isTopModal ? true : undefined,
    "data-component": "menu-fullscreen",
    "data-element": dataElement,
    "data-role": dataRole,
    menuType: menuType,
    ref: modalRef,
    role: "dialog",
    tabIndex: -1
  }, /*#__PURE__*/React.createElement(StyledMenuFullscreenHeader, {
    menuType: menuType
  }, /*#__PURE__*/React.createElement(IconButton, {
    "aria-label": locale.menuFullscreen.ariaLabels.closeButton(),
    onClick: onClose,
    "data-element": "close"
  }, /*#__PURE__*/React.createElement(Icon, {
    type: "close",
    color: isDarkVariant ? "--colorsYang100" : undefined
  }))), /*#__PURE__*/React.createElement(Box, {
    overflowY: "auto",
    scrollVariant: isDarkVariant ? "dark" : "light",
    width: "100%",
    height: "calc(100% - 40px)"
  }, /*#__PURE__*/React.createElement(StyledMenuWrapper, {
    "data-component": "menu",
    menuType: menuType,
    ref: contentRef,
    display: "flex",
    flexDirection: "column",
    role: "list",
    inFullscreenView: true
  }, /*#__PURE__*/React.createElement(MenuContext.Provider, {
    value: {
      inFullscreenView: true,
      menuType,
      inMenu: true,
      openSubmenuId: null,
      setOpenSubmenuId: /* istanbul ignore next */() => {}
    }
  }, childArray)))))))));
};
export default MenuFullscreen;