function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext } from "react";
import PropTypes from "prop-types";
import StyledDivider from "./menu-divider.style";
import MenuContext from "../menu.context";
import { StyledMenuItem } from "../menu.style";
import tagComponent from "../../../__internal__/utils/helpers/tags";
const MenuDivider = /*#__PURE__*/React.forwardRef(({
  size = "default",
  ...rest
}, ref) => {
  const menuContext = useContext(MenuContext);
  return /*#__PURE__*/React.createElement(StyledMenuItem, {
    inSubmenu: true
  }, /*#__PURE__*/React.createElement(StyledDivider, _extends({
    size: size
  }, tagComponent("menu-divider", rest), {
    menuType: menuContext.menuType,
    ref: ref
  })));
});
if (process.env.NODE_ENV !== "production") {
  MenuDivider.propTypes = {
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "size": PropTypes.oneOf(["default", "large"])
  };
}
MenuDivider.displayName = "MenuDivider";
export default MenuDivider;