function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useEffect, useContext, useMemo, useRef, useState } from "react";
import PropTypes from "prop-types";
import StyledMenuItemWrapper from "../../menu-item/menu-item.style";
import { StyledSubmenu, StyledSubmenuWrapper } from "./submenu.style";
import Events from "../../../../__internal__/utils/helpers/events";
import MenuContext from "../../menu.context";
import { characterNavigation } from "../keyboard-navigation";
import SubmenuContext from "./submenu.context";
import useClickAwayListener from "../../../../hooks/__internal__/useClickAwayListener";
import guid from "../../../../__internal__/utils/helpers/guid";
import { SCROLLABLE_BLOCK, SCROLLABLE_BLOCK_PARENT, BLOCK_INDEX_SELECTOR, ALL_CHILDREN_SELECTOR } from "../locators";
import useStableCallback from "../../../../hooks/__internal__/useStableCallback/useStableCallback";
import FixedNavigationBarContext from "../../../navigation-bar/fixed-navigation-bar.context";
const Submenu = /*#__PURE__*/React.forwardRef(({
  children,
  className,
  title,
  icon,
  submenuDirection = "right",
  onKeyDown,
  variant = "default",
  showDropdownArrow = true,
  clickToOpen,
  href,
  maxWidth,
  asPassiveItem,
  onSubmenuOpen: onSubmenuOpenProp,
  onSubmenuClose,
  onClick,
  ...rest
}, ref) => {
  const [submenuRef, setSubmenuRef] = useState(null);
  const submenuId = useRef(guid());
  const menuContext = useContext(MenuContext);
  const {
    inFullscreenView,
    openSubmenuId,
    setOpenSubmenuId,
    menuType
  } = menuContext;
  const [submenuOpen, setSubmenuOpen] = useState(false);
  const [submenuFocusId, setSubmenuFocusId] = useState(null);
  const [submenuItemIds, setSubmenuItemIds] = useState([]);
  const [characterString, setCharacterString] = useState("");
  const [applyFocusRadius, setApplyFocusRadius] = useState(false);
  const shiftTabPressed = useRef(false);
  const focusFirstMenuItemOnOpen = useRef(false);
  const numberOfChildren = submenuItemIds.length;
  const {
    submenuMaxHeight
  } = useContext(FixedNavigationBarContext);
  const onSubmenuOpen = useStableCallback(onSubmenuOpenProp);
  const blockIndex = useMemo(() => {
    const items = submenuRef?.querySelectorAll(BLOCK_INDEX_SELECTOR);
    if (items && submenuOpen && numberOfChildren) {
      const childrenArray = Array.from(items);
      const scrollableBlock = submenuRef?.querySelector(`[data-component='${SCROLLABLE_BLOCK}']`);
      const index = scrollableBlock ? childrenArray.indexOf(scrollableBlock) : -1;
      return scrollableBlock?.querySelector(`[data-component='${SCROLLABLE_BLOCK_PARENT}']`) ? index + 1 : index;
    }
    return -1;
  }, [submenuOpen, numberOfChildren, submenuRef]);
  const characterTimer = useRef(null);
  const startCharacterTimeout = useCallback(() => {
    characterTimer.current = setTimeout(() => {
      setCharacterString("");
    }, 1500);
  }, []);
  const restartCharacterTimeout = useCallback(() => {
    /* istanbul ignore else */
    if (characterTimer.current) {
      clearTimeout(characterTimer.current);
    }
    startCharacterTimeout();
  }, [startCharacterTimeout]);
  const openSubmenu = useCallback(() => {
    setSubmenuOpen(true);
    setOpenSubmenuId(submenuId.current);
  }, [setOpenSubmenuId]);
  const lastMenuItemElement = useRef();
  useEffect(() => {
    const handleBorderRadiusStyling = () => {
      // Finds all ul elements that are not submenus
      const ulElements = Array.from(submenuRef?.querySelectorAll("ul:not([data-component='submenu'])") || /* istanbul ignore next */[]);

      // Terminate early if there are no ul elements as we have nothing we need to apply styles to.
      if (ulElements.length === 0) return;

      // Get the last menu item in the submenu
      const lastMenuItem = Array.from(submenuRef?.querySelectorAll("[data-component='menu-item']") || /* istanbul ignore next */[]).pop();
      lastMenuItemElement.current = lastMenuItem;

      // Get the last segment block
      const lastSegmentBlock = ulElements.pop();

      // Get all the menu items from the last segment block
      const segmentBlockMenuItems = Array.from(lastSegmentBlock?.querySelectorAll("[data-component='menu-item']") || /* istanbul ignore next */[]);

      // Get the last menu item in the last segment block
      const lastMenuItemInSegmentBlock = segmentBlockMenuItems.pop();
      // Check if the last item in the segment block is the same as the last MenuItem in the submenu
      const menuItemsMatch = !!lastMenuItemInSegmentBlock && lastMenuItemInSegmentBlock === lastMenuItem;
      setApplyFocusRadius(menuItemsMatch);
    };
    if (submenuOpen && submenuRef) {
      handleBorderRadiusStyling();
    }
  }, [submenuOpen, submenuRef]);
  useEffect(() => {
    if (submenuOpen && onSubmenuOpen) {
      onSubmenuOpen();
    }
  }, [submenuOpen, onSubmenuOpen]);
  const closeSubmenu = useCallback(() => {
    shiftTabPressed.current = false;
    setSubmenuOpen(false);
    setSubmenuFocusId(null);
    if (onSubmenuClose) {
      onSubmenuClose();
    }
    setCharacterString("");
  }, [onSubmenuClose]);
  useEffect(() => {
    if (openSubmenuId && openSubmenuId !== submenuId.current) {
      closeSubmenu();
    }
  }, [openSubmenuId, closeSubmenu]);
  const findCurrentIndex = useCallback(id => {
    const index = submenuItemIds.findIndex(itemId => itemId === id);
    return index;
  }, [submenuItemIds]);
  const handleKeyDown = useCallback(event => {
    if (!submenuOpen) {
      if (Events.isEnterKey(event) || Events.isSpaceKey(event) || Events.isDownKey(event) || Events.isUpKey(event)) {
        event.preventDefault();
        openSubmenu();
        focusFirstMenuItemOnOpen.current = !href;
      }
    }
    if (submenuOpen) {
      const index = findCurrentIndex(submenuFocusId);
      let nextIndex = index;
      if (href && !submenuFocusId) {
        if (Events.isDownKey(event) || Events.isUpKey(event) || Events.isTabKey(event) && !Events.isShiftKey(event)) {
          event.preventDefault();
          setSubmenuFocusId(submenuItemIds[0]);
          return;
        }
      }
      if (Events.isTabKey(event) && !Events.isShiftKey(event)) {
        if (nextIndex === numberOfChildren - 1) {
          closeSubmenu();
          return;
        }
        shiftTabPressed.current = false;
        nextIndex += 1;
      }
      if (Events.isTabKey(event) && Events.isShiftKey(event)) {
        if (nextIndex <= 0) {
          closeSubmenu();
          return;
        }
        shiftTabPressed.current = true;
        nextIndex -= 1;
      }
      if (Events.isDownKey(event)) {
        event.preventDefault();
        shiftTabPressed.current = false;
        if (nextIndex < numberOfChildren - 1) {
          nextIndex += 1;
        }
      }
      if (Events.isUpKey(event)) {
        event.preventDefault();
        shiftTabPressed.current = false;
        setApplyFocusRadius(false);
        if (nextIndex > 0) {
          nextIndex -= 1;
        }
      }
      if (Events.isEscKey(event)) {
        onKeyDown?.(event);
        closeSubmenu();
        return;
      }
      if (Events.isHomeKey(event)) {
        event.preventDefault();
        shiftTabPressed.current = false;
        nextIndex = 0;
      }
      if (Events.isEndKey(event)) {
        event.preventDefault();
        shiftTabPressed.current = false;
        nextIndex = numberOfChildren - 1;
      }
      if (event.key.length === 1) {
        event.stopPropagation();
        shiftTabPressed.current = false;
        if (characterTimer.current) {
          restartCharacterTimeout();
        } else {
          startCharacterTimeout();
        }
        setCharacterString(`${characterString}${event.key.toLowerCase()}`);
      } else {
        setCharacterString("");
      }
      const eventIsFromInput = Events.composedPath(event).find(p => p.getAttribute("data-element") === "input" || p.getAttribute("data-element") === "input-icon-toggle");
      if (!eventIsFromInput) {
        if (Events.isEnterKey(event)) {
          /* timeout enforces that the "closeSubmenu" method will be run after 
            the browser navigates to the specified href of the menu-item. */
          setTimeout(() => closeSubmenu(), 0);
        }
        if (href && Events.isEnterKey(event)) {
          closeSubmenu();
          return;
        }
      }
      if (nextIndex !== index) {
        setSubmenuFocusId(submenuItemIds[nextIndex]);
      }
    }
  }, [submenuItemIds, submenuOpen, href, numberOfChildren, submenuFocusId, findCurrentIndex, openSubmenu, closeSubmenu, onKeyDown, characterString, restartCharacterTimeout, startCharacterTimeout]);
  useEffect(() => {
    /* istanbul ignore else */
    if (submenuRef && children) {
      const items = submenuRef?.querySelectorAll(ALL_CHILDREN_SELECTOR);

      /* istanbul ignore else */
      if (items) {
        setSubmenuItemIds(Array.from(items).map(item => item.getAttribute("id")));
      }
    }
  }, [children, submenuOpen, submenuRef]);
  useEffect(() => {
    if (focusFirstMenuItemOnOpen.current && submenuOpen && !submenuFocusId && submenuItemIds.length) {
      focusFirstMenuItemOnOpen.current = false;
      setSubmenuFocusId(submenuItemIds[0]);
    }
  }, [submenuOpen, submenuFocusId, submenuItemIds]);
  const handleClickAway = () => {
    document.removeEventListener("click", handleClickAway);
    closeSubmenu();
  };
  const handleClickInside = useClickAwayListener(handleClickAway);
  const handleClick = event => {
    openSubmenu();
    if (onClick) {
      onClick(event);
    }
  };
  useEffect(() => {
    const items = submenuRef?.querySelectorAll(ALL_CHILDREN_SELECTOR);
    if (items && characterString !== "") {
      const submenuChildren = Array.from(items);
      const nextItem = characterNavigation(characterString, submenuChildren);
      if (nextItem) {
        setSubmenuFocusId(nextItem.id);
      }
    }
  }, [submenuRef, characterString, submenuItemIds]);
  if (inFullscreenView) {
    return /*#__PURE__*/React.createElement(StyledSubmenuWrapper, {
      "data-component": "submenu-wrapper",
      inFullscreenView: inFullscreenView,
      asPassiveItem: asPassiveItem,
      menuType: menuContext.menuType,
      onClick: handleClickInside
    }, /*#__PURE__*/React.createElement(StyledMenuItemWrapper, _extends({}, rest, {
      onClick: asPassiveItem ? undefined : onClick,
      className: className,
      menuType: menuType,
      ref: ref,
      href: href,
      variant: variant,
      inFullscreenView: inFullscreenView,
      asDiv: asPassiveItem
    }), title), /*#__PURE__*/React.createElement(StyledSubmenu, {
      "data-component": "submenu",
      variant: variant,
      menuType: menuType,
      inFullscreenView: inFullscreenView,
      ref: setSubmenuRef,
      applyFocusRadiusStyling: false
    }, /*#__PURE__*/React.createElement(SubmenuContext.Provider, {
      value: {
        handleKeyDown,
        blockIndex,
        updateFocusId: setSubmenuFocusId
      }
    }, children)));
  }
  return /*#__PURE__*/React.createElement(StyledSubmenuWrapper, {
    "data-component": "submenu-wrapper",
    onMouseOver: !clickToOpen ? () => openSubmenu() : undefined,
    onMouseLeave: () => closeSubmenu(),
    isSubmenuOpen: submenuOpen,
    onClick: handleClickInside,
    ref: setSubmenuRef
  }, /*#__PURE__*/React.createElement(StyledMenuItemWrapper, _extends({}, rest, {
    className: className,
    menuType: menuType,
    ref: ref,
    icon: icon,
    tabIndex: -1,
    variant: variant,
    isOpen: submenuOpen,
    hasSubmenu: true,
    showDropdownArrow: showDropdownArrow,
    onKeyDown: handleKeyDown,
    onClick: handleClick,
    clickToOpen: clickToOpen,
    href: href,
    maxWidth: maxWidth,
    "aria-expanded": submenuOpen
  }), title), submenuOpen && /*#__PURE__*/React.createElement(StyledSubmenu, {
    "data-component": "submenu",
    submenuDirection: submenuDirection,
    variant: variant,
    menuType: menuType,
    role: blockIndex === 0 ? "presentation" : "list",
    maxHeight: submenuMaxHeight,
    applyFocusRadiusStyling: applyFocusRadius
  }, /*#__PURE__*/React.createElement(SubmenuContext.Provider, {
    value: {
      submenuFocusId,
      handleKeyDown,
      blockIndex,
      updateFocusId: setSubmenuFocusId,
      shiftTabPressed: shiftTabPressed.current
    }
  }, children)));
});
if (process.env.NODE_ENV !== "production") {
  Submenu.propTypes = {
    "ariaLabel": PropTypes.string,
    "asPassiveItem": PropTypes.bool,
    "children": PropTypes.node,
    "className": PropTypes.string,
    "clickToOpen": PropTypes.bool,
    "href": PropTypes.string,
    "icon": PropTypes.string,
    "maxWidth": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "onClick": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "onSubmenuClose": PropTypes.func,
    "onSubmenuOpen": PropTypes.func,
    "showDropdownArrow": PropTypes.bool,
    "submenuDirection": PropTypes.string,
    "title": PropTypes.string,
    "variant": PropTypes.oneOf(["alternate", "default"])
  };
}
Submenu.displayName = "submenu";
export default Submenu;