function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import { filterStyledSystemMarginProps } from "../../style/utils";
import useMediaQuery from "../../hooks/useMediaQuery";
import useLocale from "../../hooks/__internal__/useLocale";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import StyledLoader from "./loader.style";
import StyledLoaderSquare from "./loader-square.style";
export const Loader = ({
  variant = "default",
  "aria-label": ariaLabel,
  size = "medium",
  isInsideButton,
  isActive = true,
  ...rest
}) => {
  const l = useLocale();
  const reduceMotion = !useMediaQuery("screen and (prefers-reduced-motion: no-preference)");
  const loaderSquareProps = {
    isInsideButton,
    isActive,
    size,
    variant
  };

  // FE-6368 has been raised for the below, changed hex values for design tokens (when added)
  return /*#__PURE__*/React.createElement(StyledLoader, _extends({
    "aria-label": ariaLabel || l.loader.loading(),
    role: "progressbar"
  }, tagComponent("loader", rest), filterStyledSystemMarginProps(rest)), reduceMotion ? l.loader.loading() : /*#__PURE__*/React.createElement(React.Fragment, null, ["#13A038", "#0092DB", "#8F49FE"].map(color => /*#__PURE__*/React.createElement(StyledLoaderSquare, _extends({
    key: color,
    backgroundColor: variant === "gradient" ? color : "var(--colorsActionMajor500)"
  }, loaderSquareProps)))));
};
export default Loader;