function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import { StyledSpinnerWrapper, StyledLabel, StyledSpinnerCircleSvg } from "./loader-spinner.style";
import { filterStyledSystemMarginProps } from "../../style/utils";
import useLocale from "../../hooks/__internal__/useLocale";
import useMediaQuery from "../../hooks/useMediaQuery";
import Typography from "../typography";
export const LoaderSpinner = ({
  spinnerLabel,
  size = "medium",
  showSpinnerLabel = true,
  variant = "action",
  isTracked = false,
  hasMotion = true,
  animationTime,
  ...rest
}) => {
  const locale = useLocale();
  const reduceMotion = !useMediaQuery("screen and (prefers-reduced-motion: no-preference)");
  const isLabelDark = variant !== "inverse" && variant !== "gradient-white";
  const renderSpinnerLabel = /*#__PURE__*/React.createElement(StyledLabel, {
    "data-role": "visible-label",
    variant: "span",
    fontWeight: "500",
    size: size,
    color: isLabelDark ? "var(--colorsUtilityYin090);" : "var(--colorsActionMajorYang100);",
    fontSize: size === "extra-large" ? "var(--sizing200)" : "var(--sizing175)",
    lineHeight: size === "extra-large" ? "var(--sizing300)" : "var(--sizing250)"
  }, spinnerLabel || locale.loaderSpinner.loading());
  const isGradientVariant = variant === "gradient-white" || variant === "gradient-grey";
  const calculateDefaultAnimationTime = () => {
    if (animationTime) {
      return animationTime;
    }
    return isGradientVariant ? 2 : 1;
  };
  return /*#__PURE__*/React.createElement(StyledSpinnerWrapper, _extends({
    size: size,
    role: "status"
  }, tagComponent("loader-spinner", rest), filterStyledSystemMarginProps(rest)), reduceMotion ? renderSpinnerLabel : /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(StyledSpinnerCircleSvg, {
    role: "presentation",
    size: size,
    variant: variant,
    hasMotion: hasMotion,
    isTracked: isTracked,
    isGradientVariant: isGradientVariant,
    animationTime: calculateDefaultAnimationTime(),
    viewBox: "0 0 24 24"
  }, /*#__PURE__*/React.createElement("circle", {
    "data-role": "outer-arc"
  }), /*#__PURE__*/React.createElement("circle", {
    "data-role": "inner-arc"
  })), showSpinnerLabel ? renderSpinnerLabel : /*#__PURE__*/React.createElement(Typography, {
    "data-role": "hidden-label",
    variant: "span",
    screenReaderOnly: true
  }, spinnerLabel || locale.loaderSpinner.loading())));
};
export default LoaderSpinner;