import React from "react";
import { MarginProps } from "styled-system";
import { TagProps } from "../../__internal__/utils/helpers/tags/tags";
import { LoaderSpinnerSizes, LoaderSpinnerVariants } from "./loader-spinner.config";
export interface LoaderSpinnerProps extends MarginProps, TagProps {
    /**
     * Use the spinnerLabel prop to override the default `"Loading..."` label with
     * any custom string
     */
    spinnerLabel?: string;
    /**
     * The size prop allows a specific size to be set, ranging from
     * `extra-small` to `extra-large`
     */
    size?: LoaderSpinnerSizes;
    /**
     * If set to `false` no visual label will be displayed, however
     * a visually hidden label will still be available for assistive technologies
     */
    showSpinnerLabel?: boolean;
    /**
     * The variant prop can be used to change the appearance of the component.
     * Typically both the outer and inner spinner will change color,
     * however there will still be sufficient contrast between them
     */
    variant?: LoaderSpinnerVariants;
    /** If set to `false` all motion will be suspended */
    hasMotion?: boolean;
    /**
     * If set to `true` the animation type will become tracked, this is
     * used specifically for when wait times are predictable
     */
    isTracked?: boolean;
    /**
     * The total animation time (in seconds). Default animation is time `1` second.
     * For any gradient variants the default animation time is `2` seconds
     */
    animationTime?: number;
}
export declare const LoaderSpinner: ({ spinnerLabel, size, showSpinnerLabel, variant, isTracked, hasMotion, animationTime, ...rest }: LoaderSpinnerProps) => React.JSX.Element;
export default LoaderSpinner;
