function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import { filterStyledSystemMarginProps } from "../../style/utils";
import useMediaQuery from "../../hooks/useMediaQuery";
import useLocale from "../../hooks/__internal__/useLocale";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import StyledLoaderBar, { InnerBar, StyledLoader } from "./loader-bar.style";
export const LoaderBar = ({
  size = "medium",
  ...rest
}) => {
  const l = useLocale();
  const reduceMotion = !useMediaQuery("screen and (prefers-reduced-motion: no-preference)");
  return /*#__PURE__*/React.createElement(StyledLoader, _extends({
    "aria-label": l.loader.loading(),
    role: "progressbar"
  }, tagComponent("loader-bar", rest), filterStyledSystemMarginProps(rest)), reduceMotion ? l.loader.loading() : /*#__PURE__*/React.createElement(StyledLoaderBar, {
    size: size
  }, /*#__PURE__*/React.createElement(InnerBar, {
    size: size
  })));
};
LoaderBar.DisplayName = "Loader Bar";
export default LoaderBar;