function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useMemo, useState } from "react";
import PropTypes from "prop-types";
import Icon from "../icon";
import MenuContext from "../menu/menu.context";
import { StyledLink, StyledContent } from "./link.style";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import useLocale from "../../hooks/__internal__/useLocale";
const Link = /*#__PURE__*/React.forwardRef(({
  children,
  className,
  onKeyDown,
  href,
  onClick,
  onMouseDown,
  icon,
  iconAlign = "left",
  isSkipLink,
  disabled,
  ariaLabel,
  rel,
  tooltipMessage,
  tooltipPosition,
  target,
  variant = "default",
  isDarkBackground,
  placeholderTabIndex,
  removeAriaLabelOnIcon,
  ...rest
}, ref) => {
  const [hasFocus, setHasFocus] = useState(false);
  const l = useLocale();
  const {
    inMenu
  } = useContext(MenuContext);
  const renderLinkIcon = (currentAlignment = "left") => {
    const hasProperAlignment = icon && iconAlign === currentAlignment;
    return hasProperAlignment ? /*#__PURE__*/React.createElement(Icon, {
      type: icon,
      disabled: disabled,
      ariaLabel: removeAriaLabelOnIcon ? undefined : ariaLabel,
      tooltipMessage: tooltipMessage,
      tooltipPosition: tooltipPosition
    }) : null;
  };
  const ariaProps = useMemo(() => {
    const restObject = rest;
    return Object.keys(restObject).filter(key => key.startsWith("aria")).reduce((obj, key) => {
      obj[key] = restObject[key];
      return obj;
    }, {});
  }, [rest]);
  const componentProps = {
    onKeyDown,
    onMouseDown,
    onClick,
    disabled,
    target,
    ref,
    href,
    rel,
    "aria-label": ariaLabel,
    ...ariaProps,
    onFocus: () => setHasFocus(true),
    onBlur: () => setHasFocus(false)
  };
  const buttonProps = {
    type: "button"
  };
  const createLinkBasedOnType = () => {
    let type = "a";
    if (onClick && !href) {
      type = "button";
    }
    return /*#__PURE__*/React.createElement(type, type === "button" ? {
      ...componentProps,
      ...buttonProps
    } : {
      ...componentProps,
      ...(placeholderTabIndex && href === undefined && !onClick && {
        tabIndex: -1
      })
    }, /*#__PURE__*/React.createElement(React.Fragment, null, renderLinkIcon(), /*#__PURE__*/React.createElement(StyledContent, null, isSkipLink ? l.link.skipLinkLabel() : children), renderLinkIcon("right")));
  };
  return /*#__PURE__*/React.createElement(StyledLink, _extends({
    isSkipLink: isSkipLink,
    disabled: disabled,
    className: className,
    iconAlign: iconAlign,
    hasContent: Boolean(children),
    variant: variant,
    isDarkBackground: isDarkBackground,
    isMenuItem: inMenu
  }, tagComponent("link", rest), isSkipLink && {
    "data-element": "skip-link"
  }, {
    hasFocus: hasFocus
  }), createLinkBasedOnType());
});
if (process.env.NODE_ENV !== "production") {
  Link.propTypes = {
    "aria-activedescendant": PropTypes.string,
    "aria-atomic": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-autocomplete": PropTypes.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-checked": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-colcount": PropTypes.number,
    "aria-colindex": PropTypes.number,
    "aria-colspan": PropTypes.number,
    "aria-controls": PropTypes.string,
    "aria-current": PropTypes.oneOfType([PropTypes.oneOf(["date", "false", "location", "page", "step", "time", "true"]), PropTypes.bool]),
    "aria-describedby": PropTypes.string,
    "aria-details": PropTypes.string,
    "aria-disabled": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-dropeffect": PropTypes.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": PropTypes.string,
    "aria-expanded": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-flowto": PropTypes.string,
    "aria-grabbed": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-haspopup": PropTypes.oneOfType([PropTypes.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), PropTypes.bool]),
    "aria-hidden": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-invalid": PropTypes.oneOfType([PropTypes.oneOf(["false", "grammar", "spelling", "true"]), PropTypes.bool]),
    "aria-keyshortcuts": PropTypes.string,
    "aria-label": PropTypes.string,
    "aria-labelledby": PropTypes.string,
    "aria-level": PropTypes.number,
    "aria-live": PropTypes.oneOf(["assertive", "off", "polite"]),
    "aria-modal": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiline": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiselectable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-orientation": PropTypes.oneOf(["horizontal", "vertical"]),
    "aria-owns": PropTypes.string,
    "aria-placeholder": PropTypes.string,
    "aria-posinset": PropTypes.number,
    "aria-pressed": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-readonly": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-relevant": PropTypes.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-roledescription": PropTypes.string,
    "aria-rowcount": PropTypes.number,
    "aria-rowindex": PropTypes.number,
    "aria-rowspan": PropTypes.number,
    "aria-selected": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-setsize": PropTypes.number,
    "aria-sort": PropTypes.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": PropTypes.number,
    "aria-valuemin": PropTypes.number,
    "aria-valuenow": PropTypes.number,
    "aria-valuetext": PropTypes.string,
    "ariaLabel": PropTypes.string,
    "children": PropTypes.node,
    "className": PropTypes.string,
    "disabled": PropTypes.bool,
    "hasFocus": PropTypes.bool,
    "href": PropTypes.string,
    "icon": PropTypes.oneOf(["accessibility_web", "add", "admin", "alert_on", "alert", "analysis", "app_facebook", "app_instagram", "app_tiktok", "app_twitter", "app_youtube", "apps", "arrow_bottom_right_circle", "arrow_down", "arrow_left_boxed", "arrow_left_right_small", "arrow_left_small", "arrow_left", "arrow_right_small", "arrow_right", "arrow_top_left_circle", "arrow_up", "arrow", "arrows_left_right", "attach", "bank_with_card", "bank", "basket_with_squares", "basket", "bed", "bill_paid", "bill_unpaid", "bin", "biometric", "block_arrow_right", "blocked_square", "blocked", "bold", "box_arrow_left", "box_arrow_right", "boxed_shapes", "bulk_destroy", "bullet_list_dotted", "bullet_list_numbers", "bullet_list", "business", "calendar_pay_date", "calendar_today", "calendar", "call", "camera", "car_lock", "car_money", "car_repair", "card_view", "card_wallet", "caret_down", "caret_large_down", "caret_large_left", "caret_large_right", "caret_large_up", "caret_left", "caret_right", "caret_up", "cart", "cash", "chart_bar", "chart_line", "chart_pie", "chat_notes", "chat", "check_all", "check_none", "chevron_down_thick", "chevron_down", "chevron_left_thick", "chevron_left", "chevron_right_thick", "chevron_right", "chevron_up_thick", "chevron_up", "circle_with_dots", "circles_connection", "clock", "close", "cloud_co2", "coins", "collaborate", "computer_clock", "connect_off", "connect", "construction", "contact_card", "contacts", "copy", "create", "credit_card_slash", "credit_card", "cross_circle", "cross", "csv", "dashboard", "delete", "delivery", "disconnect", "disputed", "document_right_align", "document_tick", "document_vertical_lines", "download", "draft", "drag_vertical", "drag", "drill", "dropdown", "duplicate", "edit", "edited", "ellipsis_horizontal", "ellipsis_vertical", "email_switch", "email", "entry", "envelope_dollar", "envelope_euro", "error_square", "error", "euro", "expand", "export", "factory", "favourite_lined", "favourite", "fax", "feedback", "file_excel", "file_generic", "file_image", "file_pdf", "file_word", "files_leaning", "filter_new", "filter", "fit_height", "fit_width", "flag", "folder", "form_refresh", "gift", "go", "graduation_hat", "graph", "grid", "hand_cash_coins", "hand_cash_note", "heart_pulse", "help", "hide", "home", "image", "import", "in_progress", "in_transit", "individual", "info", "intranet", "italic", "job_seeked", "key", "laptop", "leaf", "ledger_arrow_left", "ledger_arrow_right", "ledger", "lightbulb_off", "lightbulb_on", "like_no", "like", "link_cloud", "link_on", "link", "list_view", "location", "locked", "logout", "lookup", "marker", "message", "microphone", "minimise", "minus_large", "minus", "mobile", "money_bag", "none", "old_warning", "palm_tree", "pause_circle", "pause", "pdf", "people_switch", "people", "percentage_boxed", "person_info", "person_tick", "person", "petrol_pump", "phone", "piggy_bank", "pin", "plane", "play_circle", "play", "plus_large", "plus", "pound", "print", "progress", "progressed", "protect", "question_hollow", "question_mark", "question", "recruiting", "refresh_clock", "refresh", "remove", "sage_coin", "save", "scan", "search", "send", "services", "settings_old", "settings", "share", "shop", "sort_down", "sort_up", "spanner", "split_container", "split", "square_dot", "squares_nine", "stacked_boxes", "stacked_squares", "submitted", "support_online", "sync", "tag", "talk", "target_man", "target", "theatre_masks", "three_boxes", "tick_circle", "tick_thick", "tick", "true_tick", "u_turn_left", "u_turn_right", "undo", "unlocked", "upload", "uploaded", "video", "view", "volunteering", "warning", "website", "welfare"]),
    "iconAlign": PropTypes.oneOf(["left", "right"]),
    "isDarkBackground": PropTypes.bool,
    "isSkipLink": PropTypes.bool,
    "onClick": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "onMouseDown": PropTypes.func,
    "placeholderTabIndex": PropTypes.bool,
    "rel": PropTypes.string,
    "removeAriaLabelOnIcon": PropTypes.bool,
    "target": PropTypes.string,
    "tooltipMessage": PropTypes.string,
    "tooltipPosition": PropTypes.oneOf(["bottom", "left", "right", "top"]),
    "variant": PropTypes.oneOf(["default", "negative", "neutral"])
  };
}
export { Link };
Link.displayName = "Link";
export default Link;