function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import { StyledLinkPreview, StyledPreviewWrapper, StyledCloseIconWrapper, StyledTitle, StyledDescription, StyledUrl } from "./link-preview.style";
import Image from "../image";
import Preview from "../preview";
import IconButton from "../icon-button";
import Icon from "../icon";
import Placeholder from "./__internal__/placeholder.component";
const SCHEME_SEPARATOR = "://";
export const LinkPreview = ({
  as,
  description,
  image,
  isLoading,
  onClose,
  title,
  url,
  ...rest
}) => {
  const loadingState = isLoading || !url;
  const canRenderAsLink = !loadingState && as !== "div";
  const imageProps = () => {
    return {
      src: image?.url,
      alt: image?.alt || "Link preview image",
      height: "152px"
    };
  };
  const displayUrl = () => {
    if (url?.includes(SCHEME_SEPARATOR)) {
      const startIndex = url.indexOf(SCHEME_SEPARATOR) + SCHEME_SEPARATOR.length;
      return url.substring(startIndex);
    }
    return url;
  };
  const linkProps = canRenderAsLink ? {
    href: url,
    target: "_blank",
    rel: "noopener noreferrer"
  } : {};
  return /*#__PURE__*/React.createElement(StyledLinkPreview, _extends({
    as: loadingState ? "div" : as,
    tabIndex: loadingState || as === "div" ? -1 : 0
  }, linkProps, rest), imageProps().src ? /*#__PURE__*/React.createElement(Image, imageProps()) : /*#__PURE__*/React.createElement(Placeholder, null), /*#__PURE__*/React.createElement(StyledPreviewWrapper, {
    isLoading: loadingState
  }, /*#__PURE__*/React.createElement(Preview, {
    loading: loadingState,
    lines: 4
  }, /*#__PURE__*/React.createElement(StyledTitle, null, title), /*#__PURE__*/React.createElement(StyledDescription, null, /*#__PURE__*/React.createElement("div", null, description)), /*#__PURE__*/React.createElement(StyledUrl, null, displayUrl()))), onClose && as === "div" && /*#__PURE__*/React.createElement(StyledCloseIconWrapper, null, /*#__PURE__*/React.createElement(IconButton, {
    "aria-label": "link preview close button",
    onClick: () => onClose(url)
  }, /*#__PURE__*/React.createElement(Icon, {
    type: "close"
  }))));
};
LinkPreview.displayName = "LinkPreview";
export default LinkPreview;