import React from "react";
import PropTypes from "prop-types";
import styled from "styled-components";
export const StyledPlaceHolder = styled.div`
  overflow: hidden;
  position: relative;
  height: 152px;
  min-width: 152px;
  background-color: var(--colorsUtilityMajor025);
  border-bottom-left-radius: var(--borderRadius100);
  border-top-left-radius: var(--borderRadius100);
`;
const Circle = styled.div`
  height: 22px;
  width: 22px;
  border-radius: 50%;
  background-color: var(--colorsUtilityMajor100);
  position: absolute;
  left: 22px;
  top: 30px;
`;
const Square = styled.div`
  height: 200px;
  width: 200px;
  transform: rotate(45deg);
  background-color: ${({
  color
}) => color};
  position: absolute;
  border-radius: 2%;
  top: ${({
  top
}) => top};
  left: ${({
  left
}) => left};
`;
const Placeholder = () => /*#__PURE__*/React.createElement(StyledPlaceHolder, {
  "data-component": "link preview image placeholder"
}, /*#__PURE__*/React.createElement(Circle, null), /*#__PURE__*/React.createElement(Square, {
  color: "var(--colorsUtilityMajor050)",
  top: "120px",
  left: "-64px"
}), /*#__PURE__*/React.createElement(Square, {
  color: "var(--colorsUtilityMajor150)",
  top: "96px",
  left: "16px"
}));
export default Placeholder;