function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef, useEffect } from "react";
import PropTypes from "prop-types";
import Label from "../../__internal__/label";
import StyledInlineInputs, { StyledContentContainer, StyledInlineInput } from "./inline-inputs.style";
import FormSpacingProvider from "../../__internal__/form-spacing-provider";
import useIsAboveBreakpoint from "../../hooks/__internal__/useIsAboveBreakpoint";
import useFormSpacing from "../../hooks/__internal__/useFormSpacing";
const columnWrapper = (children, gutter) => {
  return React.Children.map(children, input => {
    return /*#__PURE__*/React.createElement(StyledInlineInput, {
      gutter: gutter,
      "data-element": "inline-input"
    }, input);
  });
};
const InlineInputs = ({
  adaptiveLabelBreakpoint,
  label,
  labelAlign,
  labelId,
  htmlFor,
  children = null,
  className = "",
  gutter = "none",
  inputWidth,
  labelInline = true,
  labelWidth,
  required,
  isOptional,
  ...rest
}) => {
  const largeScreen = useIsAboveBreakpoint(adaptiveLabelBreakpoint);
  const ref = useRef(null);
  let inlineLabel = labelInline;
  if (adaptiveLabelBreakpoint) {
    inlineLabel = largeScreen;
  }
  function renderLabel() {
    if (!label) return null;
    return /*#__PURE__*/React.createElement(Label, {
      align: labelAlign,
      labelId: labelId,
      inline: inlineLabel,
      htmlFor: htmlFor,
      isRequired: required,
      optional: isOptional
    }, label);
  }
  const marginProps = useFormSpacing(rest);
  useEffect(() => {
    if (required) {
      const elements = Array.from(ref.current?.querySelectorAll("input") || /* istanbul ignore next */[]);
      elements.forEach(el => el.setAttribute("required", ""));
    }
  }, [required]);
  return /*#__PURE__*/React.createElement(StyledInlineInputs, _extends({
    gutter: gutter,
    "data-component": "inline-inputs",
    className: className,
    labelWidth: labelWidth,
    labelInline: inlineLabel,
    ref: ref
  }, marginProps), renderLabel(), /*#__PURE__*/React.createElement(StyledContentContainer, {
    gutter: gutter,
    "data-element": "inline-inputs-container",
    inputWidth: inputWidth
  }, /*#__PURE__*/React.createElement(FormSpacingProvider, {
    marginBottom: undefined
  }, columnWrapper(children, gutter))));
};
InlineInputs.displayName = "InlineInputs";
export default InlineInputs;