import styled, { css } from "styled-components";
import { margin, layout, background, padding } from "styled-system";
import { baseTheme } from "../../style/themes";
const StyledImage = styled.div.attrs(({
  src,
  children,
  hidden = false,
  position,
  top,
  right,
  bottom,
  left
}) => ({
  ...(src && {
    as: "img"
  }),
  children: src ? undefined : children,
  src,
  hidden,
  position,
  top,
  right,
  bottom,
  left
}))`
  ${margin}
  ${layout}
  ${padding}

  ${({
  position,
  top,
  right,
  bottom,
  left
}) => css`
    position: ${position};
    top: ${top};
    right: ${right};
    bottom: ${bottom};
    left: ${left};
  `}

  ${({
  as
}) => as !== "img" && css`
      ${background}
    `}
`;
StyledImage.defaultProps = {
  backgroundPosition: "center",
  backgroundRepeat: "no-repeat",
  backgroundSize: "cover",
  theme: baseTheme
};
export { StyledImage };