function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import { StyledImage } from "./image.style";
export const Image = ({
  alt,
  decorative = false,
  src,
  children,
  position,
  top,
  right,
  bottom,
  left,
  ...rest
}) => {
  !(!src || !children) ? process.env.NODE_ENV !== "production" ? invariant(false, "The 'Image' component renders as an 'img' element when the 'src' prop is used and therefore does not accept children.") : invariant(false) : void 0;
  !(!src || alt && typeof alt === "string" || decorative) ? process.env.NODE_ENV !== "production" ? invariant(false, "Please use the 'decorative' prop if the 'alt' text should be an empty value or provide an 'alt' string when rendering the 'Image' component as an 'img' element.") : invariant(false) : void 0;
  return /*#__PURE__*/React.createElement(StyledImage, _extends({
    alt: alt,
    decorative: decorative,
    src: src,
    position: position,
    top: top,
    right: right,
    bottom: bottom,
    left: left
  }, rest), children);
};
Image.displayName = "Image";
export default Image;