import styled, { css } from "styled-components";
import { shade } from "polished";
import { margin } from "styled-system";
import iconUnicodes from "./icon-unicodes";
import baseTheme from "../../style/themes/base";
import iconConfig from "./icon-config";
import browserTypeCheck, { isSafari } from "../../__internal__/utils/helpers/browser-type-check";
import styledColor from "../../style/utils/color";
import getColorValue from "../../style/utils/get-color-value";
import addFocusStyling from "../../style/utils/add-focus-styling";
function adjustIconBgSize(fontSize, bgSize) {
  const sizeValues = {
    "extra-small": 1,
    small: 2,
    medium: 3,
    large: 4,
    "extra-large": 5
  };
  if (fontSize && bgSize) {
    const fontSizeValue = sizeValues[fontSize];
    const bgSizeValue = sizeValues[bgSize];
    if (bgSizeValue < fontSizeValue) {
      // eslint-disable-next-line no-console
      console.warn(`[WARNING - Icon] The "${bgSize}" \`bgSize\` is smaller than "${fontSize}" \`fontSize\`, the \`bgSize\` has been auto adjusted to a larger size.`);
      return iconConfig.backgroundSize[fontSize];
    }
    return iconConfig.backgroundSize[bgSize];
  }
  return bgSize ? iconConfig.backgroundSize[bgSize] : undefined;
}
const oldFocusStyling = "outline: 2px solid var(--colorsSemanticFocus500);";
const StyledIcon = styled.span`
  ${({
  theme,
  color,
  bg,
  isInteractive,
  bgSize,
  bgShape,
  type,
  fontSize,
  disabled,
  hasTooltip
}) => {
  let finalColor;
  let finalHoverColor;
  let bgColor;
  let bgHoverColor;
  const adjustedBgSize = adjustIconBgSize(fontSize, bgSize);
  try {
    if (disabled) {
      finalColor = "var(--colorsYin030)";
      finalHoverColor = "var(--colorsYin030)";
    } else if (color) {
      const {
        color: renderedColor
      } = styledColor({
        color,
        theme
      });
      finalColor = renderedColor;
      finalHoverColor = shade(0.2, getColorValue(renderedColor));
    } else {
      finalColor = "var(--colorsYin090)";
      finalHoverColor = "var(--colorsYin090)";
    }
    if (bg) {
      const {
        backgroundColor
      } = styledColor({
        bg,
        theme
      });
      bgColor = backgroundColor;
      bgHoverColor = shade(0.2, getColorValue(backgroundColor));
    } else {
      bgColor = "transparent";
      bgHoverColor = "transparent";
    }
  } catch (e) {
    // eslint-disable-next-line no-console
    console.error(e);
  }
  return css`
      position: relative;
      color: ${finalColor};
      background-color: ${bgColor};
      vertical-align: middle;
      align-items: center;
      display: inline-flex;
      justify-content: center;
      height: ${adjustedBgSize};
      width: ${adjustedBgSize};
      ${bgShape ? `border-radius: ${iconConfig.backgroundShape[bgShape]}` : ""};

      ${isInteractive && css`
        &:hover {
          color: ${finalHoverColor};
          background-color: ${bgHoverColor};
        }
      `}

      &::before {
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;

        font-family: CarbonIcons;
        content: "${iconUnicodes[type]}";
        font-style: normal;
        font-weight: normal;
        vertical-align: middle;

        ${fontSize && css`
          font-size: ${iconConfig.iconSize[fontSize]};
          line-height: ${iconConfig.iconSize[fontSize]};
        `}

        ${type === "services" && browserTypeCheck(window) && css`
          margin-top: ${fontSize === "small" ? "-7px" : "-8px"};
        `}

        ${type === "services" && isSafari(navigator) && !browserTypeCheck(window) && css`
          margin-top: -6px;
        `}
        
        display: block;
      }

      ${hasTooltip && `
        :focus {
          ${!theme.focusRedesignOptOut ? addFocusStyling() : oldFocusStyling}
        }
      `}

      ${margin}
    `;
}}
`;
StyledIcon.defaultProps = {
  theme: baseTheme
};
export default StyledIcon;