import React, { useContext, useMemo } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import Tooltip from "../tooltip";
import { filterStyledSystemMarginProps } from "../../style/utils";
import { TooltipContext } from "../../__internal__/tooltip-provider";
import StyledIcon from "./icon.style";
import { ICON_TOOLTIP_POSITIONS } from "./icon-config";
import { TabTitleContext } from "../tabs/__internal__/tab-title";
import Logger from "../../__internal__/utils/logger";
let deprecatedExtraSmallBgSizeTriggered = false;
const Icon = /*#__PURE__*/React.forwardRef(({
  "aria-hidden": ariaHidden,
  ariaLabel,
  bg,
  bgShape,
  bgSize,
  className,
  color,
  "data-element": dataElement,
  "data-role": dataRole,
  disabled,
  focusable = true,
  fontSize = "small",
  id,
  inputSize,
  isPartOfInput,
  tabIndex,
  tooltipMessage,
  tooltipPosition,
  tooltipVisible,
  tooltipBgColor,
  tooltipFontColor,
  tooltipFlipOverrides,
  tooltipId,
  type,
  role,
  ...rest
}, ref) => {
  const flipBehaviourCheck = Array.isArray(tooltipFlipOverrides) && tooltipFlipOverrides.every(override => ICON_TOOLTIP_POSITIONS.includes(override));
  if (!deprecatedExtraSmallBgSizeTriggered && bgSize === "extra-small") {
    deprecatedExtraSmallBgSizeTriggered = true;
    Logger.deprecate("The `extra-small` variant of the `bgSize` prop for `Icon` component has been deprecated and will soon be removed.");
  }
  if (tooltipFlipOverrides) {
    !flipBehaviourCheck ? process.env.NODE_ENV !== "production" ? invariant(false, `The tooltipFlipOverrides prop supplied to \`Icon\` must be an array containing some or all of ["top", "bottom", "left", "right"].`) : invariant(false) : void 0;
  }
  const isInteractive = !!tooltipMessage && !disabled;
  const {
    tooltipPosition: tooltipPositionFromContext,
    focusable: focusableFromContext,
    tooltipVisible: tooltipVisibleFromContext,
    disabled: disabledFromContext,
    target
  } = useContext(TooltipContext);
  const {
    isInTab
  } = useContext(TabTitleContext);

  /** Return Icon type with overrides */
  const iconType = useMemo(() => {
    // switch tweaks icon names for actual icons in the set
    switch (type) {
      case "help":
        return "question";
      case "maintenance":
        return "settings";
      case "new":
        return "gift";
      case "success":
        return "tick";
      case "messages":
      case "email":
        return "message";
      default:
        return type;
    }
  }, [type]);
  const isFocusable = focusableFromContext !== undefined ? focusableFromContext : focusable;
  const hasTooltip = !disabled && !disabledFromContext && !!tooltipMessage && isFocusable;
  const computedTabIndex = useMemo(() => {
    if (isInTab) {
      return undefined;
    }
    return hasTooltip && tabIndex === undefined ? 0 : tabIndex;
  }, [isInTab, hasTooltip, tabIndex]);
  const styledIconProps = {
    "aria-hidden": ariaHidden,
    "aria-label": ariaLabel,
    bg,
    bgSize: bgSize || fontSize,
    bgShape,
    className: className || undefined,
    color,
    "data-component": "icon",
    "data-element": dataElement ?? iconType,
    "data-role": dataRole ?? "icon",
    disabled: disabledFromContext || disabled,
    fontSize,
    hasTooltip,
    id,
    isInteractive,
    key: "icon",
    ref,
    role,
    tabIndex: computedTabIndex,
    type: iconType,
    ...filterStyledSystemMarginProps(rest)
  };
  const shouldShowTooltip = () => {
    return tooltipVisibleFromContext !== undefined ? tooltipVisibleFromContext : tooltipVisible;
  };
  if (tooltipMessage) {
    const visible = disabled ? undefined : shouldShowTooltip();
    return /*#__PURE__*/React.createElement(Tooltip, {
      message: tooltipMessage,
      position: tooltipPositionFromContext || tooltipPosition,
      type: type,
      id: tooltipId,
      isVisible: visible,
      isPartOfInput: isPartOfInput,
      inputSize: inputSize,
      bgColor: tooltipBgColor,
      fontColor: tooltipFontColor,
      flipOverrides: tooltipFlipOverrides,
      target: target
    }, /*#__PURE__*/React.createElement(StyledIcon, styledIconProps));
  }
  return /*#__PURE__*/React.createElement(StyledIcon, styledIconProps);
});
if (process.env.NODE_ENV !== "production") {
  Icon.propTypes = {
    "aria-hidden": PropTypes.bool,
    "ariaLabel": PropTypes.string,
    "bg": PropTypes.string,
    "bgShape": PropTypes.oneOf(["circle", "rounded-rect", "square"]),
    "bgSize": PropTypes.oneOf(["extra-large", "extra-small", "large", "medium", "small"]),
    "className": PropTypes.string,
    "color": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "disabled": PropTypes.bool,
    "focusable": PropTypes.bool,
    "fontSize": PropTypes.oneOf(["extra-large", "large", "medium", "small"]),
    "id": PropTypes.string,
    "inputSize": PropTypes.oneOf(["large", "medium", "small"]),
    "isPartOfInput": PropTypes.bool,
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "role": PropTypes.string,
    "tabIndex": PropTypes.number,
    "tooltipBgColor": PropTypes.string,
    "tooltipFlipOverrides": PropTypes.arrayOf(PropTypes.oneOf(["bottom", "left", "right", "top"])),
    "tooltipFontColor": PropTypes.string,
    "tooltipId": PropTypes.string,
    "tooltipMessage": PropTypes.node,
    "tooltipPosition": PropTypes.oneOf(["bottom", "left", "right", "top"]),
    "tooltipVisible": PropTypes.bool,
    "type": PropTypes.oneOf(["accessibility_web", "add", "admin", "alert_on", "alert", "analysis", "app_facebook", "app_instagram", "app_tiktok", "app_twitter", "app_youtube", "apps", "arrow_bottom_right_circle", "arrow_down", "arrow_left_boxed", "arrow_left_right_small", "arrow_left_small", "arrow_left", "arrow_right_small", "arrow_right", "arrow_top_left_circle", "arrow_up", "arrow", "arrows_left_right", "attach", "bank_with_card", "bank", "basket_with_squares", "basket", "bed", "bill_paid", "bill_unpaid", "bin", "biometric", "block_arrow_right", "blocked_square", "blocked", "bold", "box_arrow_left", "box_arrow_right", "boxed_shapes", "bulk_destroy", "bullet_list_dotted", "bullet_list_numbers", "bullet_list", "business", "calendar_pay_date", "calendar_today", "calendar", "call", "camera", "car_lock", "car_money", "car_repair", "card_view", "card_wallet", "caret_down", "caret_large_down", "caret_large_left", "caret_large_right", "caret_large_up", "caret_left", "caret_right", "caret_up", "cart", "cash", "chart_bar", "chart_line", "chart_pie", "chat_notes", "chat", "check_all", "check_none", "chevron_down_thick", "chevron_down", "chevron_left_thick", "chevron_left", "chevron_right_thick", "chevron_right", "chevron_up_thick", "chevron_up", "circle_with_dots", "circles_connection", "clock", "close", "cloud_co2", "coins", "collaborate", "computer_clock", "connect_off", "connect", "construction", "contact_card", "contacts", "copy", "create", "credit_card_slash", "credit_card", "cross_circle", "cross", "csv", "dashboard", "delete", "delivery", "disconnect", "disputed", "document_right_align", "document_tick", "document_vertical_lines", "download", "draft", "drag_vertical", "drag", "drill", "dropdown", "duplicate", "edit", "edited", "ellipsis_horizontal", "ellipsis_vertical", "email_switch", "email", "entry", "envelope_dollar", "envelope_euro", "error_square", "error", "euro", "expand", "export", "factory", "favourite_lined", "favourite", "fax", "feedback", "file_excel", "file_generic", "file_image", "file_pdf", "file_word", "files_leaning", "filter_new", "filter", "fit_height", "fit_width", "flag", "folder", "form_refresh", "gift", "go", "graduation_hat", "graph", "grid", "hand_cash_coins", "hand_cash_note", "heart_pulse", "help", "hide", "home", "image", "import", "in_progress", "in_transit", "individual", "info", "intranet", "italic", "job_seeked", "key", "laptop", "leaf", "ledger_arrow_left", "ledger_arrow_right", "ledger", "lightbulb_off", "lightbulb_on", "like_no", "like", "link_cloud", "link_on", "link", "list_view", "location", "locked", "logout", "lookup", "maintenance", "marker", "message", "messages", "microphone", "minimise", "minus_large", "minus", "mobile", "money_bag", "new", "none", "old_warning", "palm_tree", "pause_circle", "pause", "pdf", "people_switch", "people", "percentage_boxed", "person_info", "person_tick", "person", "petrol_pump", "phone", "piggy_bank", "pin", "plane", "play_circle", "play", "plus_large", "plus", "pound", "print", "progress", "progressed", "protect", "question_hollow", "question_mark", "question", "recruiting", "refresh_clock", "refresh", "remove", "sage_coin", "save", "scan", "search", "send", "services", "settings_old", "settings", "share", "shop", "sort_down", "sort_up", "spanner", "split_container", "split", "square_dot", "squares_nine", "stacked_boxes", "stacked_squares", "submitted", "success", "support_online", "sync", "tag", "talk", "target_man", "target", "theatre_masks", "three_boxes", "tick_circle", "tick_thick", "tick", "true_tick", "u_turn_left", "u_turn_right", "undo", "unlocked", "upload", "uploaded", "video", "view", "volunteering", "warning", "website", "welfare"]).isRequired
  };
}
Icon.displayName = "Icon";
export default Icon;