import React from "react";
import { MarginProps } from "styled-system";
import { TagProps } from "../../__internal__/utils/helpers/tags/tags";
import { StyledIconProps } from "./icon.style";
import { IconType } from "./icon-type";
import { TooltipPositions } from "../tooltip/tooltip.config";
export declare type LegacyIconTypes = "help" | "maintenance" | "new" | "success" | "messages";
export interface IconProps extends Omit<StyledIconProps, "type">, MarginProps, Omit<TagProps, "data-component"> {
    /** Set whether icon should be recognised by assistive technologies */
    "aria-hidden"?: boolean;
    /** Aria label for accessibility purposes */
    ariaLabel?: string;
    /** Id passed to the icon. */
    id?: string;
    /** The ARIA role to be applied to the Icon */
    role?: string;
    /** The message to be displayed within the tooltip */
    tooltipMessage?: React.ReactNode;
    /** The position to display the tooltip */
    tooltipPosition?: TooltipPositions;
    /** Control whether the tooltip is visible */
    tooltipVisible?: boolean;
    /** Override background color of the Tooltip, provide any color from palette or any valid css color value. */
    tooltipBgColor?: string;
    /** Override font color of the Tooltip, provide any color from palette or any valid css color value. */
    tooltipFontColor?: string;
    /** Overrides the default flip behaviour of the Tooltip */
    tooltipFlipOverrides?: TooltipPositions[];
    /** Id passed to the tooltip container, used for accessibility purposes */
    tooltipId?: string;
    /**
     * Icon type
     *
     * The full list of types can be seen [here](https://carbon.sage.com/?path=/docs/icon--list-of-icons#list-of-icons).
     */
    type: IconType | LegacyIconTypes;
    /** @ignore @private */
    focusable?: boolean;
    /** @ignore @private */
    isPartOfInput?: boolean;
    /** @ignore @private */
    inputSize?: "small" | "medium" | "large";
    /** @ignore @private */
    tabIndex?: number;
}
declare const Icon: React.ForwardRefExoticComponent<IconProps & React.RefAttributes<HTMLSpanElement>>;
export default Icon;
