function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import { filterStyledSystemMarginProps } from "../../style/utils";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import { StyledHeading, StyledHeadingIcon, StyledSubHeader, StyledHeader, StyledSeparator, StyledHeaderHelp, StyledHeadingTitle, StyledDivider, StyledHeaderContent, StyledHeadingBackButton, StyledHeadingPills } from "./heading.style";
import useLocale from "../../hooks/__internal__/useLocale";
export const Heading = ({
  children,
  backLink,
  divider = true,
  help,
  helpAriaLabel,
  helpLink,
  pills,
  separator = false,
  subheader,
  subtitleId,
  headingType = "h1",
  title,
  titleId,
  ...rest
}) => {
  const getHelp = () => {
    return /*#__PURE__*/React.createElement(StyledHeaderHelp, {
      "data-element": "help",
      tooltipPosition: "right",
      href: helpLink,
      ariaLabel: helpAriaLabel
    }, help);
  };
  const l = useLocale();
  const getBackButton = () => {
    const backButtonProps = typeof backLink === "string" ? {
      href: backLink
    } : {
      onClick: backLink
    };
    return /*#__PURE__*/React.createElement(StyledHeadingBackButton
    // this event allows an element to be focusable on click event on IE
    , _extends({
      "aria-label": l.heading.backLinkAriaLabel(),
      "data-element": "back",
      onMouseDown: e => e.currentTarget.focus()
    }, backButtonProps), /*#__PURE__*/React.createElement(StyledHeadingIcon, {
      type: "chevron_left"
    }));
  };
  const getSubheader = () => {
    return /*#__PURE__*/React.createElement(StyledSubHeader, {
      "data-element": "subtitle",
      id: subtitleId,
      hasBackLink: !!backLink,
      hasSeparator: separator
    }, subheader);
  };
  const getPills = () => {
    return /*#__PURE__*/React.createElement(StyledHeadingPills, {
      "data-element": "pills"
    }, pills);
  };
  const marginProps = filterStyledSystemMarginProps(rest);
  const dataAttributes = {
    "data-element": rest["data-element"],
    "data-role": rest["data-role"]
  };
  return title ? /*#__PURE__*/React.createElement(StyledHeading, _extends({}, tagComponent("heading", dataAttributes), marginProps), /*#__PURE__*/React.createElement(StyledHeader, {
    "data-element": "header-container",
    divider: divider,
    subheader: !!subheader,
    hasBackLink: !!backLink
  }, backLink && getBackButton(), /*#__PURE__*/React.createElement(StyledHeaderContent, null, /*#__PURE__*/React.createElement(StyledHeadingTitle, {
    withMargin: !!pills || !!help,
    variant: headingType,
    "data-element": "title",
    id: titleId
  }, title), (help || helpLink) && getHelp(), pills && getPills()), separator && /*#__PURE__*/React.createElement(StyledSeparator, null), subheader && getSubheader()), divider && /*#__PURE__*/React.createElement(StyledDivider, {
    "data-element": "divider"
  }), children) : null;
};
export default Heading;