import React from "react";
import { MarginProps } from "styled-system";
import { TagProps } from "../../__internal__/utils/helpers/tags/tags";
export declare type HeadingType = "h1" | "h2" | "h3" | "h4" | "h5";
export interface HeadingProps extends MarginProps, TagProps {
    /** Child elements */
    children?: React.ReactNode;
    /** Defines the title for the heading. */
    title?: React.ReactNode;
    /** Defines the title id for the heading. */
    titleId?: string;
    /** Defines the subheader for the heading. */
    subheader?: React.ReactNode;
    /** Defines the subtitle id for the heading. */
    subtitleId?: string;
    /** Defines the HTML heading element of the title. */
    headingType?: HeadingType;
    /** Defines the help text for the heading. */
    help?: string;
    /** Defines the help link for the heading. */
    helpLink?: string;
    /** Defines the a href for the back link. */
    backLink?: string | ((ev: React.MouseEvent<HTMLAnchorElement> | React.MouseEvent<HTMLButtonElement> | React.KeyboardEvent<HTMLAnchorElement> | React.KeyboardEvent<HTMLButtonElement>) => void);
    /** Adds a divider below the heading and the content. */
    divider?: boolean;
    /** Adds a separator between the title and the subheader. */
    separator?: boolean;
    /** Pills that will be added after the title. */
    pills?: React.ReactNode;
    /** Aria label for rendered help component */
    helpAriaLabel?: string;
}
export declare const Heading: ({ children, backLink, divider, help, helpAriaLabel, helpLink, pills, separator, subheader, subtitleId, headingType, title, titleId, ...rest }: HeadingProps) => React.JSX.Element | null;
export default Heading;
