import React from "react";
import { TextboxProps } from "../textbox";
declare type EventValue = {
    formattedValue: string;
    rawValue: string;
};
declare type CustomTarget = {
    name?: string;
    id?: string;
    value: EventValue;
};
export interface CustomEvent extends Omit<React.ChangeEvent<HTMLInputElement>, "target"> {
    target: CustomTarget;
}
export interface GroupedCharacterProps extends Omit<TextboxProps, "onChange" | "onBlur"> {
    /** Default input value if component is meant to be used as an uncontrolled component */
    defaultValue?: string;
    /** pattern by which input value should be grouped */
    groups: number[];
    /** Handler for blur event */
    onBlur?: (ev: CustomEvent) => void;
    /** Handler for change event if input is meant to be used as a controlled component */
    onChange?: (ev: CustomEvent) => void;
    /** character to be used as separator - has to be a 1 character string */
    separator: string;
    /** Input value if component is meant to be used as a controlled component */
    value?: string;
}
export declare const GroupedCharacter: React.ForwardRefExoticComponent<GroupedCharacterProps & React.RefAttributes<HTMLInputElement>>;
export default GroupedCharacter;
