function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import styled from "styled-components";
import Box from "../box";
import NavigationBar from "../navigation-bar";
const StyledLogo = styled(Box)`
  display: flex;
  align-items: center;
  margin-left: var(--spacing200);
  margin-right: var(--spacing300);

  & > * {
    max-height: 100%;
  }

  @media (min-width: 600px) {
    margin-left: var(--spacing300);
  }
  @media (min-width: 960px) {
    margin-left: var(--spacing400);
  }
  @media (min-width: 1260px) {
    margin-left: var(--spacing500);
  }
`;
const GlobalHeader = ({
  children,
  logo,
  ...rest
}) => {
  return /*#__PURE__*/React.createElement(NavigationBar, _extends({
    isGlobal: true
  }, rest), logo && /*#__PURE__*/React.createElement(StyledLogo, {
    "data-element": "global-header-logo-wrapper"
  }, logo), children);
};
GlobalHeader.displayName = "GlobalHeader";
export default GlobalHeader;