function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef, useContext } from "react";
import PropTypes from "prop-types";
import { SidebarContext } from "../sidebar/sidebar.component";
import { ModalContext } from "../modal/modal.component";
import FormSummary from "./__internal__/form-summary.component";
import { StyledForm, StyledFormContent, StyledFormFooter, StyledLeftButtons, StyledRightButtons, StyledFullWidthButtons } from "./form.style";
import { formSpacing } from "./form.config";
import FormSpacingProvider from "../../__internal__/form-spacing-provider";
export const Form = ({
  children,
  saveButton,
  leftSideButtons,
  rightSideButtons,
  errorCount,
  warningCount,
  onSubmit,
  buttonAlignment = "right",
  stickyFooter,
  fieldSpacing = 3,
  noValidate = true,
  height,
  fullWidthButtons = false,
  footerPadding = {},
  ...rest
}) => {
  const {
    isInSidebar
  } = useContext(SidebarContext);
  const {
    isInModal
  } = useContext(ModalContext);
  const formRef = useRef(null);
  const formFooterRef = useRef(null);
  const hasPadding = !!Object.keys(footerPadding).length;
  const renderFooter = !!(saveButton || leftSideButtons || rightSideButtons || errorCount || warningCount);
  const classNames = `${stickyFooter ? "sticky" : ""} ${hasPadding ? "padded" : ""}`.trimEnd();
  return /*#__PURE__*/React.createElement(StyledForm, _extends({
    ref: formRef,
    stickyFooter: stickyFooter,
    onSubmit: onSubmit,
    "data-component": "form",
    fieldSpacing: fieldSpacing,
    noValidate: noValidate,
    isInSidebar: isInSidebar,
    height: height,
    isInModal: isInModal
  }, rest), /*#__PURE__*/React.createElement(StyledFormContent, {
    "data-element": "form-content",
    className: stickyFooter ? "sticky" : "",
    stickyFooter: stickyFooter,
    isInModal: isInModal
  }, /*#__PURE__*/React.createElement(FormSpacingProvider, {
    marginBottom: formSpacing[fieldSpacing]
  }, children)), !fullWidthButtons && renderFooter && /*#__PURE__*/React.createElement(StyledFormFooter, _extends({
    "data-element": "form-footer",
    className: classNames,
    ref: formFooterRef,
    stickyFooter: stickyFooter,
    buttonAlignment: buttonAlignment,
    isInModal: isInModal
  }, footerPadding), leftSideButtons && /*#__PURE__*/React.createElement(StyledLeftButtons, {
    buttonAlignment: buttonAlignment
  }, leftSideButtons), /*#__PURE__*/React.createElement(FormSummary, {
    errorCount: errorCount,
    warningCount: warningCount
  }, saveButton), rightSideButtons && /*#__PURE__*/React.createElement(StyledRightButtons, {
    buttonAlignment: buttonAlignment
  }, rightSideButtons)), fullWidthButtons && renderFooter && /*#__PURE__*/React.createElement(StyledFormFooter, _extends({
    "data-element": "form-footer",
    className: classNames,
    ref: formFooterRef,
    stickyFooter: stickyFooter,
    buttonAlignment: buttonAlignment,
    fullWidthButtons: fullWidthButtons
  }, footerPadding), leftSideButtons && /*#__PURE__*/React.createElement(StyledLeftButtons, {
    fullWidthButtons: fullWidthButtons
  }, leftSideButtons), rightSideButtons && /*#__PURE__*/React.createElement(StyledRightButtons, {
    fullWidthButtons: fullWidthButtons
  }, rightSideButtons), /*#__PURE__*/React.createElement(StyledFullWidthButtons, null, /*#__PURE__*/React.createElement(FormSummary, {
    fullWidth: fullWidthButtons,
    errorCount: errorCount,
    warningCount: warningCount
  }, saveButton))));
};
Form.displayName = "Form";
export default Form;